/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test.impl;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;

public class CmmnJobTestHelper {
    public static void waitForJobExecutorToProcessAllJobs(CmmnEngine cmmnEngine, long maxMillisToWait, long intervalMillis, boolean shutdownExecutorWhenFinished) {
        CmmnJobTestHelper.waitForJobExecutorToProcessAllJobs(cmmnEngine.getCmmnEngineConfiguration(), maxMillisToWait, intervalMillis, shutdownExecutorWhenFinished);
    }

    public static void waitForJobExecutorToProcessAllJobs(final CmmnEngineConfiguration cmmnEngineConfiguration, long maxMillisToWait, long intervalMillis, boolean shutdownExecutorWhenFinished) {
        CmmnJobTestHelper.waitForExecutorToProcessAllJobs(cmmnEngineConfiguration.getAsyncExecutor(), new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return cmmnEngineConfiguration.getCmmnManagementService().createJobQuery().count() > 0L || cmmnEngineConfiguration.getCmmnManagementService().createTimerJobQuery().count() > 0L;
            }
        }, maxMillisToWait, intervalMillis, shutdownExecutorWhenFinished);
    }

    public static void waitForAsyncHistoryExecutorToProcessAllJobs(final CmmnEngineConfiguration cmmnEngineConfiguration, long maxMillisToWait, long intervalMillis, boolean shutdownExecutorWhenFinished) {
        CmmnJobTestHelper.waitForExecutorToProcessAllJobs(cmmnEngineConfiguration.getAsyncHistoryExecutor(), new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return cmmnEngineConfiguration.getCmmnManagementService().createHistoryJobQuery().count() > 0L;
            }
        }, maxMillisToWait, intervalMillis, shutdownExecutorWhenFinished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForExecutorToProcessAllJobs(AsyncExecutor asyncExecutor, Callable<Boolean> callable, long maxMillisToWait, long intervalMillis, boolean shutdownExecutorWhenFinished) {
        if (asyncExecutor == null) {
            throw new FlowableException("No async executor set. Check the cmmn engine configuration.");
        }
        asyncExecutor.start();
        try {
            Timer timer = new Timer();
            JobInterruptionTask jobInterruptionTask = new JobInterruptionTask();
            timer.schedule((TimerTask)jobInterruptionTask, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !jobInterruptionTask.isMaxTimeUsed()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = callable.call();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new FlowableException("Time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            if (shutdownExecutorWhenFinished) {
                asyncExecutor.shutdown();
            }
        }
    }

    public static class JobInterruptionTask
    extends TimerTask {
        protected boolean maxTimeUsed;

        @Override
        public void run() {
            this.maxTimeUsed = true;
        }

        public boolean isMaxTimeUsed() {
            return this.maxTimeUsed;
        }

        public void setMaxTimeUsed(boolean maxTimeUsed) {
            this.maxTimeUsed = maxTimeUsed;
        }
    }
}

