/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.entitylink.api.EntityLink;

public class GetEntityLinkChildrenForCaseInstanceCmd
implements Command<List<EntityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseInstanceId;

    public GetEntityLinkChildrenForCaseInstanceCmd(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public List<EntityLink> execute(CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CaseInstance caseInstance = (CaseInstance)cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(this.caseInstanceId);
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("Cannot find case instance with id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        return cmmnEngineConfiguration.getEntityLinkServiceConfiguration().getEntityLinkService().findEntityLinksByScopeIdAndType(this.caseInstanceId, "cmmn", "child");
    }
}

