/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class IdentityLinkDeletedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public IdentityLinkDeletedHistoryJsonTransformer(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("cmmn-identity-link-deleted");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return this.getHistoricIdentityLinkEntity(historicalData, commandContext) != null;
    }

    protected HistoricIdentityLinkEntity getHistoricIdentityLinkEntity(ObjectNode historicalData, CommandContext commandContext) {
        return this.cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().getHistoricIdentityLink(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricIdentityLinkService historicIdentityLinkService = this.cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService();
        HistoricIdentityLinkEntity historicIdentityLinkEntity = this.getHistoricIdentityLinkEntity(historicalData, commandContext);
        if (historicIdentityLinkEntity != null) {
            historicIdentityLinkService.deleteHistoricIdentityLink(historicIdentityLinkEntity);
        }
    }
}

