/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.spring;

import java.util.Map;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.spring.SpringContentEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ContentEngineFactoryBean
implements FactoryBean<ContentEngine>,
DisposableBean,
ApplicationContextAware {
    protected ContentEngineConfiguration contentEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected ContentEngine contentEngine;

    public void destroy() throws Exception {
        if (this.contentEngine != null) {
            this.contentEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ContentEngine getObject() throws Exception {
        this.configureExternallyManagedTransactions();
        if (this.contentEngineConfiguration.getBeans() == null) {
            this.contentEngineConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
        }
        this.contentEngine = this.contentEngineConfiguration.buildContentEngine();
        return this.contentEngine;
    }

    protected void configureExternallyManagedTransactions() {
        SpringContentEngineConfiguration engineConfiguration;
        if (this.contentEngineConfiguration instanceof SpringContentEngineConfiguration && (engineConfiguration = (SpringContentEngineConfiguration)this.contentEngineConfiguration).getTransactionManager() != null) {
            this.contentEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<ContentEngine> getObjectType() {
        return ContentEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ContentEngineConfiguration getContentEngineConfiguration() {
        return this.contentEngineConfiguration;
    }

    public void setContentEngineConfiguration(ContentEngineConfiguration contentEngineConfiguration) {
        this.contentEngineConfiguration = contentEngineConfiguration;
    }
}

