/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el.function;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.el.function.AbstractFlowableVariableExpressionFunction;
import org.flowable.variable.api.delegate.VariableScope;

public class VariableContainsExpressionFunction
extends AbstractFlowableVariableExpressionFunction {
    public VariableContainsExpressionFunction(String variableScopeName) {
        super(variableScopeName, "contains");
    }

    public static boolean contains(VariableScope variableScope, String variableName, Object ... values) {
        Object variableValue = VariableContainsExpressionFunction.getVariableValue(variableScope, variableName);
        if (variableValue != null) {
            if (variableValue instanceof String) {
                String variableStringValue = (String)variableValue;
                for (Object value : values) {
                    String stringValue = (String)value;
                    if (StringUtils.contains((CharSequence)variableStringValue, (CharSequence)stringValue)) continue;
                    return false;
                }
                return true;
            }
            if (variableValue instanceof Collection) {
                Collection collectionVariableValue = (Collection)variableValue;
                for (Object value : values) {
                    if (VariableContainsExpressionFunction.collectionContains(collectionVariableValue, value)) continue;
                    return false;
                }
                return true;
            }
            if (variableValue instanceof ArrayNode) {
                ArrayNode arrayNodeVariableValue = (ArrayNode)variableValue;
                for (Object value : values) {
                    if (VariableContainsExpressionFunction.arrayNodeContains(arrayNodeVariableValue, value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean collectionContains(Collection collection, Object value) {
        if (value instanceof Number) {
            for (Object collectionValue : collection) {
                if (collectionValue instanceof Long && ((Number)value).longValue() == ((Long)collectionValue).longValue()) {
                    return true;
                }
                if (collectionValue instanceof Integer && ((Number)value).intValue() == ((Integer)collectionValue).intValue()) {
                    return true;
                }
                if (collectionValue instanceof Double && ((Number)value).doubleValue() == ((Double)collectionValue).doubleValue()) {
                    return true;
                }
                if (collectionValue instanceof Float && ((Number)value).floatValue() == ((Float)collectionValue).floatValue()) {
                    return true;
                }
                if (!(collectionValue instanceof Short) || ((Number)value).shortValue() != ((Short)collectionValue).shortValue()) continue;
                return true;
            }
            return false;
        }
        return collection.contains(value);
    }

    public static boolean arrayNodeContains(ArrayNode arrayNode, Object value) {
        for (JsonNode jsonNode : arrayNode) {
            if (value == null && jsonNode.isNull()) {
                return true;
            }
            if (value == null) continue;
            if (value instanceof String && jsonNode.isTextual() && StringUtils.equals((CharSequence)jsonNode.asText(), (CharSequence)((String)value))) {
                return true;
            }
            if (value instanceof Number && jsonNode.isLong() && jsonNode.longValue() == ((Number)value).longValue()) {
                return true;
            }
            if (value instanceof Number && jsonNode.isDouble() && jsonNode.doubleValue() == ((Number)value).doubleValue()) {
                return true;
            }
            if (value instanceof Number && jsonNode.isInt() && jsonNode.intValue() == ((Number)value).intValue()) {
                return true;
            }
            if (!(value instanceof Boolean) || !jsonNode.isBoolean() || jsonNode.booleanValue() != ((Boolean)value).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

