/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.FlowableFunctionDelegate;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionFactoryResolver;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.el.FlowableAstFunctionCreator;
import org.flowable.common.engine.impl.el.FlowableElContext;
import org.flowable.common.engine.impl.el.FlowableExpressionFactory;
import org.flowable.common.engine.impl.el.FlowableFunctionMapper;
import org.flowable.common.engine.impl.el.JsonNodeELResolver;
import org.flowable.common.engine.impl.el.JuelExpression;
import org.flowable.common.engine.impl.el.ParsingElContext;
import org.flowable.common.engine.impl.el.ReadOnlyMapELResolver;
import org.flowable.common.engine.impl.el.VariableContainerELResolver;
import org.flowable.common.engine.impl.javax.el.ArrayELResolver;
import org.flowable.common.engine.impl.javax.el.BeanELResolver;
import org.flowable.common.engine.impl.javax.el.CompositeELResolver;
import org.flowable.common.engine.impl.javax.el.CouldNotResolvePropertyELResolver;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.common.engine.impl.javax.el.ExpressionFactory;
import org.flowable.common.engine.impl.javax.el.ListELResolver;
import org.flowable.common.engine.impl.javax.el.MapELResolver;
import org.flowable.common.engine.impl.javax.el.ValueExpression;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;

public class DefaultExpressionManager
implements ExpressionManager {
    protected ExpressionFactory expressionFactory = ExpressionFactoryResolver.resolveExpressionFactory();
    protected List<FlowableFunctionDelegate> functionDelegates;
    protected BiFunction<String, String, FlowableFunctionDelegate> functionResolver;
    protected List<FlowableAstFunctionCreator> astFunctionCreators;
    protected ELContext parsingElContext;
    protected Map<Object, Object> beans;
    protected DeploymentCache<Expression> expressionCache;
    protected int expressionTextLengthCacheLimit = -1;

    public DefaultExpressionManager() {
        this(null);
    }

    public DefaultExpressionManager(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public Expression createExpression(String text) {
        Expression cachedExpression;
        if (this.isCacheEnabled(text) && (cachedExpression = this.expressionCache.get(text)) != null) {
            return cachedExpression;
        }
        if (this.parsingElContext == null) {
            this.parsingElContext = new ParsingElContext(this.functionResolver);
        } else if (this.parsingElContext.getFunctionMapper() != null && this.parsingElContext.getFunctionMapper() instanceof FlowableFunctionMapper) {
            ((FlowableFunctionMapper)this.parsingElContext.getFunctionMapper()).setFunctionResolver(this.functionResolver);
        }
        String expressionText = text.trim();
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expressionText, Object.class);
        Expression expression = this.createJuelExpression(text, valueExpression);
        if (this.isCacheEnabled(text)) {
            this.expressionCache.add(text, expression);
        }
        return expression;
    }

    protected boolean isCacheEnabled(String text) {
        return this.expressionCache != null && (this.expressionTextLengthCacheLimit < 0 || text.length() <= this.expressionTextLengthCacheLimit);
    }

    protected Expression createJuelExpression(String expression, ValueExpression valueExpression) {
        return new JuelExpression(this, valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    @Override
    public ELContext getElContext(VariableContainer variableContainer) {
        ELResolver elResolver = this.createElResolver(variableContainer);
        return new FlowableElContext(elResolver, this.functionResolver);
    }

    protected ELResolver createElResolver(VariableContainer variableContainer) {
        ArrayList<ELResolver> elResolvers = new ArrayList<ELResolver>();
        elResolvers.add(this.createVariableElResolver(variableContainer));
        if (this.beans != null) {
            elResolvers.add(new ReadOnlyMapELResolver(this.beans));
        }
        elResolvers.add(new ArrayELResolver());
        elResolvers.add(new ListELResolver());
        elResolvers.add(new MapELResolver());
        elResolvers.add(new JsonNodeELResolver());
        ELResolver beanElResolver = this.createBeanElResolver();
        if (beanElResolver != null) {
            elResolvers.add(beanElResolver);
        }
        this.configureResolvers(elResolvers);
        CompositeELResolver compositeELResolver = new CompositeELResolver();
        for (ELResolver elResolver : elResolvers) {
            compositeELResolver.add(elResolver);
        }
        compositeELResolver.add(new CouldNotResolvePropertyELResolver());
        return compositeELResolver;
    }

    protected void configureResolvers(List<ELResolver> elResolvers) {
    }

    protected ELResolver createVariableElResolver(VariableContainer variableContainer) {
        return new VariableContainerELResolver(variableContainer);
    }

    protected ELResolver createBeanElResolver() {
        return new BeanELResolver();
    }

    @Override
    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    @Override
    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public List<FlowableFunctionDelegate> getFunctionDelegates() {
        return this.functionDelegates;
    }

    @Override
    public void setFunctionDelegates(List<FlowableFunctionDelegate> functionDelegates) {
        this.functionDelegates = functionDelegates;
        this.updateFunctionResolver();
    }

    protected void updateFunctionResolver() {
        if (this.functionDelegates != null) {
            LinkedHashMap<String, FlowableFunctionDelegate> functionDelegateMap = new LinkedHashMap<String, FlowableFunctionDelegate>();
            for (FlowableFunctionDelegate functionDelegate : this.functionDelegates) {
                for (String prefix2 : functionDelegate.prefixes()) {
                    for (String localName2 : functionDelegate.localNames()) {
                        functionDelegateMap.put(prefix2 + ":" + localName2, functionDelegate);
                    }
                }
            }
            this.functionResolver = (prefix, localName) -> (FlowableFunctionDelegate)functionDelegateMap.get(prefix + ":" + localName);
        } else {
            this.functionResolver = null;
        }
    }

    @Override
    public List<FlowableAstFunctionCreator> getAstFunctionCreators() {
        return this.astFunctionCreators;
    }

    @Override
    public void setAstFunctionCreators(List<FlowableAstFunctionCreator> astFunctionCreators) {
        this.astFunctionCreators = astFunctionCreators;
        if (this.expressionFactory instanceof FlowableExpressionFactory) {
            ((FlowableExpressionFactory)this.expressionFactory).setAstFunctionCreators(astFunctionCreators);
        }
    }

    public DeploymentCache<Expression> getExpressionCache() {
        return this.expressionCache;
    }

    public void setExpressionCache(DeploymentCache<Expression> expressionCache) {
        this.expressionCache = expressionCache;
    }

    public int getExpressionTextLengthCacheLimit() {
        return this.expressionTextLengthCacheLimit;
    }

    public void setExpressionTextLengthCacheLimit(int expressionTextLengthCacheLimit) {
        this.expressionTextLengthCacheLimit = expressionTextLengthCacheLimit;
    }
}

