/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeCreator;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.FeatureDescriptor;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import org.flowable.common.engine.impl.el.EvaluationState;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.common.engine.impl.javax.el.PropertyNotWritableException;

public class JsonNodeELResolver
extends ELResolver {
    private final boolean readOnly;

    public JsonNodeELResolver() {
        this(false);
    }

    public JsonNodeELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.isResolvable(base) ? Object.class : null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isResolvable(base)) {
            JsonNode node = (JsonNode)base;
            final Iterator keys = node.fieldNames();
            return new Iterator<FeatureDescriptor>(){

                @Override
                public boolean hasNext() {
                    return keys.hasNext();
                }

                @Override
                public FeatureDescriptor next() {
                    Object key = keys.next();
                    FeatureDescriptor feature = new FeatureDescriptor();
                    feature.setDisplayName(key == null ? "null" : key.toString());
                    feature.setName(feature.getDisplayName());
                    feature.setShortDescription("");
                    feature.setExpert(true);
                    feature.setHidden(false);
                    feature.setPreferred(true);
                    feature.setValue("type", key == null ? "null" : key.getClass());
                    feature.setValue("resolvableAtDesignTime", true);
                    return feature;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove");
                }
            };
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Class<Object> result = null;
        if (this.isResolvable(base)) {
            result = Object.class;
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Object result = null;
        if (this.isResolvable(base)) {
            JsonNode resultNode = this.getResultNode((JsonNode)base, property, context);
            result = resultNode != null && resultNode.isValueNode() ? (resultNode.isBoolean() ? Boolean.valueOf(resultNode.asBoolean()) : (resultNode.isShort() || resultNode.isInt() ? Integer.valueOf(resultNode.asInt()) : (resultNode.isLong() ? Long.valueOf(resultNode.asLong()) : (resultNode.isBigDecimal() || resultNode.isDouble() || resultNode.isFloat() ? Double.valueOf(resultNode.asDouble()) : (resultNode.isTextual() ? resultNode.asText() : (resultNode.isNull() ? null : resultNode.toString())))))) : resultNode;
            context.setPropertyResolved(true);
        }
        return result;
    }

    protected JsonNode getResultNode(JsonNode base, Object property, ELContext context) {
        if (property instanceof String) {
            JsonNode propertyNode = base.get((String)property);
            if (propertyNode != null) {
                return propertyNode;
            }
            if (!this.readOnly && base instanceof ObjectNode && context.getContext(EvaluationState.class) == EvaluationState.WRITE) {
                return ((ObjectNode)base).putObject((String)property);
            }
            return null;
        }
        if (property instanceof Number) {
            int requestedIndex = ((Number)property).intValue();
            if (requestedIndex >= 0) {
                return base.get(requestedIndex);
            }
            return base.get(base.size() + requestedIndex);
        }
        return base.get(property.toString());
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.isResolvable(base)) {
            context.setPropertyResolved(true);
        }
        return this.readOnly;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (base instanceof ObjectNode) {
            this.setValue(context, (ObjectNode)base, property, value);
        } else if (base instanceof ArrayNode) {
            this.setValue(context, (ArrayNode)base, property, value);
        }
    }

    protected void setValue(ELContext context, ObjectNode node, Object property, Object value) {
        if (this.readOnly) {
            throw new PropertyNotWritableException("resolver is read-only");
        }
        JsonNode jsonNode = this.createNode((JsonNodeCreator)node, value);
        node.set(property.toString(), jsonNode);
        context.setPropertyResolved(true);
    }

    protected void setValue(ELContext context, ArrayNode node, Object property, Object value) {
        if (this.readOnly) {
            throw new PropertyNotWritableException("resolver is read-only");
        }
        int index = this.toIndex(property);
        JsonNode jsonNode = this.createNode((JsonNodeCreator)node, value);
        node.set(index, jsonNode);
        context.setPropertyResolved(true);
    }

    protected JsonNode createNode(JsonNodeCreator nodeCreator, Object value) {
        Object jsonNode = value instanceof BigDecimal ? nodeCreator.numberNode((BigDecimal)value) : (value instanceof Boolean ? nodeCreator.booleanNode(((Boolean)value).booleanValue()) : (value instanceof Long ? nodeCreator.numberNode((Long)value) : (value instanceof Double ? nodeCreator.numberNode((Double)value) : (value instanceof JsonNode ? (JsonNode)value : (value instanceof CharSequence ? nodeCreator.textNode(value.toString()) : (value instanceof Date ? nodeCreator.textNode(((Date)value).toInstant().toString()) : (value != null ? nodeCreator.textNode(value.toString()) : nodeCreator.nullNode())))))));
        return jsonNode;
    }

    protected int toIndex(Object property) {
        int index;
        if (property instanceof Number) {
            index = ((Number)property).intValue();
        } else if (property instanceof String) {
            try {
                index = Integer.valueOf((String)property);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse array index: " + property, e);
            }
        } else {
            throw new IllegalArgumentException("Cannot coerce property to array index: " + property);
        }
        return index;
    }

    private final boolean isResolvable(Object base) {
        return base instanceof JsonNode;
    }
}

