/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.flowable.engine.impl.persistence.entity.AbstractBpmnEngineNoRevisionEntity;
import org.flowable.engine.impl.persistence.entity.CommentEntity;

public class CommentEntityImpl
extends AbstractBpmnEngineNoRevisionEntity
implements CommentEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String type;
    protected String userId;
    protected Date time;
    protected String taskId;
    protected String processInstanceId;
    protected String action;
    protected String message;
    protected String fullMessage;
    public static String MESSAGE_PARTS_MARKER = "_|_";
    public static Pattern MESSAGE_PARTS_MARKER_REGEX = Pattern.compile("_\\|_");

    public Object getPersistentState() {
        return CommentEntityImpl.class;
    }

    @Override
    public byte[] getFullMessageBytes() {
        return this.fullMessage != null ? this.fullMessage.getBytes() : null;
    }

    @Override
    public void setFullMessageBytes(byte[] fullMessageBytes) {
        this.fullMessage = fullMessageBytes != null ? new String(fullMessageBytes) : null;
    }

    @Override
    public void setMessage(String[] messageParts) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String part : messageParts) {
            if (part != null) {
                stringBuilder.append(part.replace(MESSAGE_PARTS_MARKER, " | "));
                stringBuilder.append(MESSAGE_PARTS_MARKER);
                continue;
            }
            stringBuilder.append("null");
            stringBuilder.append(MESSAGE_PARTS_MARKER);
        }
        for (int i = 0; i < MESSAGE_PARTS_MARKER.length(); ++i) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.message = stringBuilder.toString();
    }

    @Override
    public List<String> getMessageParts() {
        String[] parts;
        if (this.message == null) {
            return null;
        }
        ArrayList<String> messageParts = new ArrayList<String>();
        for (String part : parts = MESSAGE_PARTS_MARKER_REGEX.split(this.message)) {
            if ("null".equals(part)) {
                messageParts.add(null);
                continue;
            }
            messageParts.add(part);
        }
        return messageParts;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    @Override
    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getFullMessage() {
        return this.fullMessage;
    }

    @Override
    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }
}

