/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EventSubscriptionUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;

public class IntermediateThrowSignalEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final SignalEventDefinition signalEventDefinition;
    protected String signalEventName;
    protected String signalExpression;
    protected boolean processInstanceScope;

    public IntermediateThrowSignalEventActivityBehavior(ThrowEvent throwEvent, SignalEventDefinition signalEventDefinition, Signal signal) {
        if (signal != null) {
            this.signalEventName = signal.getName();
            if ("processInstance".equals(signal.getScope())) {
                this.processInstanceScope = true;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)signalEventDefinition.getSignalRef())) {
            this.signalEventName = signalEventDefinition.getSignalRef();
        } else {
            this.signalExpression = signalEventDefinition.getSignalExpression();
        }
        this.signalEventDefinition = signalEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        String eventSubscriptionName = null;
        if (this.signalEventName != null) {
            eventSubscriptionName = this.signalEventName;
        } else {
            Expression expressionObject = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager().createExpression(this.signalExpression);
            eventSubscriptionName = expressionObject.getValue((VariableContainer)execution).toString();
        }
        EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService(commandContext);
        List subscriptionEntities = null;
        if (this.processInstanceScope) {
            List entityLinks;
            subscriptionEntities = eventSubscriptionService.findSignalEventSubscriptionsByProcessInstanceAndEventName(execution.getProcessInstanceId(), eventSubscriptionName);
            if (CommandContextUtil.getProcessEngineConfiguration(commandContext).isEnableEntityLinks() && (entityLinks = CommandContextUtil.getEntityLinkService(commandContext).findEntityLinksByReferenceScopeIdAndType(execution.getProcessInstanceId(), "bpmn", "child")) != null) {
                for (EntityLink entityLink : entityLinks) {
                    if ("bpmn".equals(entityLink.getScopeType())) {
                        subscriptionEntities.addAll(eventSubscriptionService.findSignalEventSubscriptionsByProcessInstanceAndEventName(entityLink.getScopeId(), eventSubscriptionName));
                        continue;
                    }
                    if (!"cmmn".equals(entityLink.getScopeType())) continue;
                    subscriptionEntities.addAll(eventSubscriptionService.findSignalEventSubscriptionsByScopeAndEventName(entityLink.getScopeId(), "cmmn", eventSubscriptionName));
                }
            }
        } else {
            subscriptionEntities = eventSubscriptionService.findSignalEventSubscriptionsByEventName(eventSubscriptionName, execution.getTenantId());
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : subscriptionEntities) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNALED, signalEventSubscriptionEntity.getActivityId(), eventSubscriptionName, null, signalEventSubscriptionEntity.getExecutionId(), signalEventSubscriptionEntity.getProcessInstanceId(), signalEventSubscriptionEntity.getProcessDefinitionId()));
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, signalEventSubscriptionEntity.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.signalEventReceived(signalEventSubscriptionEntity, null, this.signalEventDefinition.isAsync());
                continue;
            }
            EventSubscriptionUtil.eventReceived((EventSubscriptionEntity)signalEventSubscriptionEntity, null, this.signalEventDefinition.isAsync());
        }
        CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution, true);
    }
}

