/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventInstanceBpmnUtil;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class SendEventTaskActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected SendEventServiceTask sendEventServiceTask;

    public SendEventTaskActivityBehavior(SendEventServiceTask sendEventServiceTask) {
        this.sendEventServiceTask = sendEventServiceTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        EventRegistry eventRegistry = CommandContextUtil.getEventRegistry();
        EventModel eventDefinition = null;
        eventDefinition = Objects.equals("", execution.getTenantId()) ? CommandContextUtil.getEventRepositoryService().getEventModelByKey(this.sendEventServiceTask.getEventType()) : CommandContextUtil.getEventRepositoryService().getEventModelByKey(this.sendEventServiceTask.getEventType(), execution.getTenantId());
        if (eventDefinition == null) {
            throw new FlowableException("No event definition found for event key " + this.sendEventServiceTask.getEventType());
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        boolean sendSynchronously = this.sendEventServiceTask.isSendSynchronously();
        if (!sendSynchronously) {
            JobService jobService = CommandContextUtil.getJobService();
            JobEntity job = jobService.createJob();
            job.setExecutionId(execution.getId());
            job.setProcessInstanceId(execution.getProcessInstanceId());
            job.setProcessDefinitionId(execution.getProcessDefinitionId());
            job.setElementId(this.sendEventServiceTask.getId());
            job.setElementName(this.sendEventServiceTask.getName());
            job.setJobHandlerType("async-send-event");
            if (execution.getTenantId() != null) {
                job.setTenantId(execution.getTenantId());
            }
            executionEntity.getJobs().add(job);
            jobService.createAsyncJob(job, true);
            jobService.scheduleAsyncJob(job);
        } else {
            Collection<EventPayloadInstance> eventPayloadInstances = EventInstanceBpmnUtil.createEventPayloadInstances(executionEntity, CommandContextUtil.getProcessEngineConfiguration(CommandContextUtil.getCommandContext()).getExpressionManager(), (BaseElement)execution.getCurrentFlowElement(), eventDefinition);
            EventInstanceImpl eventInstance = new EventInstanceImpl(eventDefinition, Collections.emptyList(), eventPayloadInstances);
            eventRegistry.sendEventOutbound((EventInstance)eventInstance);
        }
        if (this.sendEventServiceTask.isTriggerable()) {
            EventModel triggerEventDefinition = null;
            triggerEventDefinition = StringUtils.isNotEmpty((CharSequence)this.sendEventServiceTask.getTriggerEventType()) ? (Objects.equals("", execution.getTenantId()) ? CommandContextUtil.getEventRepositoryService().getEventModelByKey(this.sendEventServiceTask.getTriggerEventType()) : CommandContextUtil.getEventRepositoryService().getEventModelByKey(this.sendEventServiceTask.getTriggerEventType(), execution.getTenantId())) : eventDefinition;
            EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)CommandContextUtil.getEventSubscriptionService().createEventSubscriptionBuilder().eventType(triggerEventDefinition.getKey()).executionId(execution.getId()).processInstanceId(execution.getProcessInstanceId()).activityId(execution.getCurrentActivityId()).processDefinitionId(execution.getProcessDefinitionId()).scopeType("bpmn").tenantId(execution.getTenantId()).configuration(CorrelationUtil.getCorrelationKey("triggerEventCorrelationParameter", Context.getCommandContext(), executionEntity)).create();
            CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
            executionEntity.getEventSubscriptions().add(eventSubscription);
        } else if (sendSynchronously) {
            this.leave(execution);
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        if (this.sendEventServiceTask.isTriggerable()) {
            Object eventInstance = execution.getTransientVariables().get("eventInstance");
            if (eventInstance instanceof EventInstance) {
                EventInstanceBpmnUtil.handleEventInstanceOutParameters(execution, (BaseElement)this.sendEventServiceTask, (EventInstance)eventInstance);
            }
            EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService();
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
            String eventType = null;
            eventType = StringUtils.isNotEmpty((CharSequence)this.sendEventServiceTask.getTriggerEventType()) ? this.sendEventServiceTask.getTriggerEventType() : this.sendEventServiceTask.getEventType();
            EventModel eventModel = null;
            eventModel = Objects.equals("", execution.getTenantId()) ? CommandContextUtil.getEventRepositoryService().getEventModelByKey(eventType) : CommandContextUtil.getEventRepositoryService().getEventModelByKey(eventType, execution.getTenantId());
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                if (!Objects.equals(eventModel.getKey(), eventSubscription.getEventType())) continue;
                eventSubscriptionService.deleteEventSubscription(eventSubscription);
            }
            this.leave(execution);
        }
    }
}

