/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.StartProcessInstanceCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class StartProcessInstanceAsyncCmd
extends StartProcessInstanceCmd {
    public StartProcessInstanceAsyncCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        super(processInstanceBuilder);
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ProcessDefinition processDefinition = this.getProcessDefinition(processEngineConfiguration);
        this.processInstanceHelper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceHelper();
        ExecutionEntity processInstance = (ExecutionEntity)this.processInstanceHelper.createProcessInstance(processDefinition, this.businessKey, this.processInstanceName, this.overrideDefinitionTenantId, this.predefinedProcessInstanceId, this.variables, this.transientVariables, this.callbackId, this.callbackType, this.referenceId, this.referenceType, this.stageInstanceId, false);
        ExecutionEntity execution = processInstance.getExecutions().get(0);
        Process process = ProcessDefinitionUtil.getProcess(processInstance.getProcessDefinitionId());
        this.processInstanceHelper.processAvailableEventSubProcesses(processInstance, (FlowElementsContainer)process, commandContext);
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createProcessStartedEvent(execution, this.variables, false));
        }
        this.executeAsynchronous(execution, process);
        return processInstance;
    }

    protected void executeAsynchronous(ExecutionEntity execution, Process process) {
        JobService jobService = CommandContextUtil.getJobService();
        JobEntity job = jobService.createJob();
        job.setExecutionId(execution.getId());
        job.setProcessInstanceId(execution.getProcessInstanceId());
        job.setProcessDefinitionId(execution.getProcessDefinitionId());
        job.setElementId(process.getId());
        job.setElementName(process.getName());
        job.setJobHandlerType("async-continuation");
        if (execution.getTenantId() != null) {
            job.setTenantId(execution.getTenantId());
        }
        execution.getJobs().add(job);
        jobService.createAsyncJob(job, false);
        jobService.scheduleAsyncJob(job);
    }
}

