/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.AbstractBpmnEngineVariableScopeEntity;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInitializingList;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableScopeImpl;

public class ExecutionEntityImpl
extends AbstractBpmnEngineVariableScopeEntity
implements ExecutionEntity,
CountingExecutionEntity {
    private static final long serialVersionUID = 1L;
    protected FlowElement currentFlowElement;
    protected FlowableListener currentListener;
    protected FlowElement originatingCurrentFlowElement;
    protected ExecutionEntityImpl processInstance;
    protected ExecutionEntityImpl parent;
    protected List<ExecutionEntityImpl> executions;
    protected ExecutionEntityImpl superExecution;
    protected ExecutionEntityImpl subProcessInstance;
    protected String tenantId = "";
    protected String name;
    protected String description;
    protected String localizedName;
    protected String localizedDescription;
    protected Date lockTime;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent;
    protected boolean isEnded;
    protected boolean isEventScope;
    protected boolean isMultiInstanceRoot;
    protected boolean isCountEnabled;
    protected String eventName;
    protected List<EventSubscriptionEntity> eventSubscriptions;
    protected List<JobEntity> jobs;
    protected List<TimerJobEntity> timerJobs;
    protected List<TaskEntity> tasks;
    protected List<IdentityLinkEntity> identityLinks;
    protected String deleteReason;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String startActivityId;
    protected String startUserId;
    protected Date startTime;
    protected int eventSubscriptionCount;
    protected int taskCount;
    protected int jobCount;
    protected int timerJobCount;
    protected int suspendedJobCount;
    protected int deadLetterJobCount;
    protected int variableCount;
    protected int identityLinkCount;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected String deploymentId;
    protected String activityId;
    protected String activityName;
    protected String processInstanceId;
    protected String businessKey;
    protected String parentId;
    protected String superExecutionId;
    protected String rootProcessInstanceId;
    protected ExecutionEntityImpl rootProcessInstance;
    protected boolean forcedUpdate;
    protected List<VariableInstanceEntity> queryVariables;
    protected String callbackId;
    protected String callbackType;
    protected String referenceId;
    protected String referenceType;
    protected String propagatedStageInstanceId;

    public static ExecutionEntityImpl createWithEmptyRelationshipCollections() {
        ExecutionEntityImpl execution = new ExecutionEntityImpl();
        execution.executions = new ArrayList<ExecutionEntityImpl>(1);
        execution.tasks = new ArrayList<TaskEntity>(1);
        execution.variableInstances = new HashMap(1);
        execution.jobs = new ArrayList<JobEntity>(1);
        execution.timerJobs = new ArrayList<TimerJobEntity>(1);
        execution.eventSubscriptions = new ArrayList<EventSubscriptionEntity>(1);
        execution.identityLinks = new ArrayList<IdentityLinkEntity>(1);
        return execution;
    }

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("isActive", this.isActive);
        persistentState.put("isConcurrent", this.isConcurrent);
        persistentState.put("isScope", this.isScope);
        persistentState.put("isEventScope", this.isEventScope);
        persistentState.put("parentId", this.parentId);
        persistentState.put("name", this.name);
        persistentState.put("lockTime", this.lockTime);
        persistentState.put("superExecution", this.superExecutionId);
        persistentState.put("rootProcessInstanceId", this.rootProcessInstanceId);
        persistentState.put("isMultiInstanceRoot", this.isMultiInstanceRoot);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("startActivityId", this.startActivityId);
        persistentState.put("startTime", this.startTime);
        persistentState.put("startUserId", this.startUserId);
        persistentState.put("isCountEnabled", this.isCountEnabled);
        persistentState.put("eventSubscriptionCount", this.eventSubscriptionCount);
        persistentState.put("taskCount", this.taskCount);
        persistentState.put("jobCount", this.jobCount);
        persistentState.put("timerJobCount", this.timerJobCount);
        persistentState.put("suspendedJobCount", this.suspendedJobCount);
        persistentState.put("deadLetterJobCount", this.deadLetterJobCount);
        persistentState.put("variableCount", this.variableCount);
        persistentState.put("identityLinkCount", this.identityLinkCount);
        persistentState.put("callbackId", this.callbackId);
        persistentState.put("callbackType", this.callbackType);
        persistentState.put("referenceId", this.referenceId);
        persistentState.put("referenceType", this.referenceType);
        persistentState.put("propagatedStageInstanceId", this.propagatedStageInstanceId);
        return persistentState;
    }

    @Override
    public FlowElement getCurrentFlowElement() {
        String processDefinitionId;
        if (this.currentFlowElement == null && (processDefinitionId = this.getProcessDefinitionId()) != null) {
            Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
            this.currentFlowElement = process.getFlowElement(this.getCurrentActivityId(), true);
        }
        return this.currentFlowElement;
    }

    @Override
    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
        if (currentFlowElement != null) {
            this.activityId = currentFlowElement.getId();
            this.activityName = currentFlowElement.getName();
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    @Override
    public FlowableListener getCurrentFlowableListener() {
        return this.currentListener;
    }

    @Override
    public void setCurrentFlowableListener(FlowableListener currentListener) {
        this.currentListener = currentListener;
    }

    @Override
    public FlowElement getOriginatingCurrentFlowElement() {
        return this.originatingCurrentFlowElement;
    }

    @Override
    public void setOriginatingCurrentFlowElement(FlowElement flowElement) {
        this.originatingCurrentFlowElement = flowElement;
    }

    public List<ExecutionEntityImpl> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    @Override
    public void addChildExecution(ExecutionEntity executionEntity) {
        this.ensureExecutionsInitialized();
        this.executions.remove(executionEntity);
        this.executions.add((ExecutionEntityImpl)executionEntity);
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = CommandContextUtil.getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.id);
        }
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getProcessInstanceBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Override
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public ExecutionEntityImpl getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = (ExecutionEntityImpl)CommandContextUtil.getExecutionEntityManager().findById(this.processInstanceId);
        }
    }

    @Override
    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = (ExecutionEntityImpl)processInstance;
        if (processInstance != null) {
            this.processInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public boolean isProcessInstanceType() {
        return this.parentId == null;
    }

    @Override
    public ExecutionEntityImpl getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            this.parent = (ExecutionEntityImpl)CommandContextUtil.getExecutionEntityManager().findById(this.parentId);
        }
    }

    @Override
    public void setParent(ExecutionEntity parent) {
        this.parent = (ExecutionEntityImpl)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    @Override
    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    public void setSuperExecutionId(String superExecutionId) {
        this.superExecutionId = superExecutionId;
    }

    @Override
    public ExecutionEntityImpl getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(ExecutionEntity superExecution) {
        this.superExecution = (ExecutionEntityImpl)superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        this.superExecutionId = superExecution != null ? ((ExecutionEntityImpl)superExecution).getId() : null;
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = (ExecutionEntityImpl)CommandContextUtil.getExecutionEntityManager().findById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntityImpl getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(ExecutionEntity subProcessInstance) {
        this.subProcessInstance = (ExecutionEntityImpl)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = (ExecutionEntityImpl)CommandContextUtil.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(this.id);
        }
    }

    @Override
    public ExecutionEntity getRootProcessInstance() {
        this.ensureRootProcessInstanceInitialized();
        return this.rootProcessInstance;
    }

    protected void ensureRootProcessInstanceInitialized() {
        if (this.rootProcessInstance == null && this.rootProcessInstanceId != null) {
            this.rootProcessInstance = (ExecutionEntityImpl)CommandContextUtil.getExecutionEntityManager().findById(this.rootProcessInstanceId);
        }
    }

    @Override
    public void setRootProcessInstance(ExecutionEntity rootProcessInstance) {
        this.rootProcessInstance = (ExecutionEntityImpl)rootProcessInstance;
        this.rootProcessInstanceId = rootProcessInstance != null ? rootProcessInstance.getId() : null;
    }

    @Override
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    @Override
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        if (this.processInstanceId != null) {
            variableInstance.setProcessInstanceId(this.processInstanceId);
        } else {
            variableInstance.setProcessInstanceId(this.id);
        }
        variableInstance.setExecutionId(this.id);
        variableInstance.setProcessDefinitionId(this.processDefinitionId);
    }

    protected void addLoggingSessionInfo(ObjectNode loggingNode) {
        BpmnLoggingSessionUtil.fillLoggingData(loggingNode, this);
    }

    protected Collection<VariableInstanceEntity> loadVariableInstances() {
        return CommandContextUtil.getVariableService().findVariableInstancesByExecutionId(this.id);
    }

    protected VariableScopeImpl getParentVariableScope() {
        return this.getParent();
    }

    public void setVariable(String variableName, Object value, boolean fetchAllVariables) {
        this.setVariable(variableName, value, this, fetchAllVariables);
    }

    @Override
    public void setVariable(String variableName, Object value, ExecutionEntity sourceExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance((VariableInstanceEntity)this.usedVariablesCache.get(variableName), value, sourceExecution);
            }
            if (this.hasVariableLocal(variableName)) {
                this.setVariableLocal(variableName, value, sourceExecution, true);
                return;
            }
            VariableScopeImpl parentVariableScope = this.getParentVariableScope();
            if (parentVariableScope != null) {
                FlowElement localFlowElement = this.getCurrentFlowElement();
                if (localFlowElement != null) {
                    ((ExecutionEntity)parentVariableScope).setOriginatingCurrentFlowElement(localFlowElement);
                }
                if (sourceExecution == null) {
                    parentVariableScope.setVariable(variableName, value);
                } else {
                    ((ExecutionEntity)parentVariableScope).setVariable(variableName, value, sourceExecution, true);
                }
                return;
            }
            if (sourceExecution != null) {
                this.createVariableLocal(variableName, value, sourceExecution);
            } else {
                this.createVariableLocal(variableName, value);
            }
        } else if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance((VariableInstanceEntity)this.usedVariablesCache.get(variableName), value, sourceExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance((VariableInstanceEntity)this.variableInstances.get(variableName), value, sourceExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceExecution);
                this.usedVariablesCache.put(variableName, variable);
            } else {
                VariableScopeImpl parent = this.getParentVariableScope();
                if (parent != null) {
                    if (sourceExecution == null) {
                        parent.setVariable(variableName, value, fetchAllVariables);
                    } else {
                        ((ExecutionEntity)parent).setVariable(variableName, value, sourceExecution, fetchAllVariables);
                    }
                    return;
                }
                variable = this.createVariableInstance(variableName, value, sourceExecution);
                this.usedVariablesCache.put(variableName, variable);
            }
        }
    }

    public Object setVariableLocal(String variableName, Object value, boolean fetchAllVariables) {
        return this.setVariableLocal(variableName, value, this, fetchAllVariables);
    }

    @Override
    public Object setVariableLocal(String variableName, Object value, ExecutionEntity sourceExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance((VariableInstanceEntity)this.usedVariablesCache.get(variableName), value, sourceExecution);
            }
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = (VariableInstanceEntity)this.variableInstances.get(variableName);
            if (variableInstance == null) {
                variableInstance = (VariableInstanceEntity)this.usedVariablesCache.get(variableName);
            }
            if (variableInstance == null) {
                this.createVariableLocal(variableName, value, sourceExecution);
            } else {
                this.updateVariableInstance(variableInstance, value, sourceExecution);
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance((VariableInstanceEntity)this.usedVariablesCache.get(variableName), value, sourceExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance((VariableInstanceEntity)this.variableInstances.get(variableName), value, sourceExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceExecution);
            } else {
                variable = this.createVariableInstance(variableName, value, sourceExecution);
            }
            this.usedVariablesCache.put(variableName, variable);
        }
        return null;
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value) {
        return this.createVariableInstance(variableName, value, this);
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceExecution) {
        VariableInstanceEntity variableInstance = super.createVariableInstance(variableName, value);
        CountingEntityUtil.handleInsertVariableInstanceEntityCount(variableInstance);
        Clock clock = CommandContextUtil.getProcessEngineConfiguration().getClock();
        CommandContextUtil.getHistoryManager().recordVariableCreate(variableInstance, clock.getCurrentTime());
        CommandContextUtil.getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceExecution, true, this.getRelatedActivityInstanceId(sourceExecution), clock.getCurrentTime());
        return variableInstance;
    }

    protected void createVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            throw new FlowableException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        this.createVariableInstance(variableName, value, sourceActivityExecution);
    }

    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value) {
        this.updateVariableInstance(variableInstance, value, this);
    }

    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceExecution) {
        super.updateVariableInstance(variableInstance, value);
        Clock clock = CommandContextUtil.getProcessEngineConfiguration().getClock();
        CommandContextUtil.getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceExecution, true, this.getRelatedActivityInstanceId(sourceExecution), clock.getCurrentTime());
        CommandContextUtil.getHistoryManager().recordVariableUpdate(variableInstance, clock.getCurrentTime());
    }

    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance) {
        super.deleteVariableInstanceForExplicitUserCall(variableInstance);
        CountingEntityUtil.handleDeleteVariableInstanceEntityCount(variableInstance, true);
        Clock clock = CommandContextUtil.getProcessEngineConfiguration().getClock();
        CommandContextUtil.getHistoryManager().recordVariableRemoved(variableInstance);
        CommandContextUtil.getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, this, true, this.getRelatedActivityInstanceId(this), clock.getCurrentTime());
    }

    protected boolean isPropagateToHistoricVariable() {
        return false;
    }

    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new FlowableException("lazy loading outside command context");
        }
        VariableInstanceEntity variableInstance = CommandContextUtil.getVariableService().findVariableInstanceByExecutionAndName(this.id, variableName);
        return variableInstance;
    }

    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new FlowableException("lazy loading outside command context");
        }
        return CommandContextUtil.getVariableService().findVariableInstancesByExecutionAndNames(this.id, variableNames);
    }

    @Override
    public List<EventSubscriptionEntity> getEventSubscriptions() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = CommandContextUtil.getEventSubscriptionService().findEventSubscriptionsByExecution(this.id);
        }
    }

    @Override
    public List<JobEntity> getJobs() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    protected void ensureJobsInitialized() {
        if (this.jobs == null) {
            this.jobs = CommandContextUtil.getJobService().findJobsByExecutionId(this.id);
        }
    }

    @Override
    public List<TimerJobEntity> getTimerJobs() {
        this.ensureTimerJobsInitialized();
        return this.timerJobs;
    }

    protected void ensureTimerJobsInitialized() {
        if (this.timerJobs == null) {
            this.timerJobs = CommandContextUtil.getTimerJobService().findTimerJobsByExecutionId(this.id);
        }
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = CommandContextUtil.getTaskService().findTasksByExecutionId(this.id);
        }
    }

    @Override
    public List<TaskEntity> getTasks() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinks() {
        this.ensureIdentityLinksInitialized();
        return this.identityLinks;
    }

    protected void ensureIdentityLinksInitialized() {
        if (this.identityLinks == null) {
            this.identityLinks = CommandContextUtil.getIdentityLinkService().findIdentityLinksByProcessInstanceId(this.id);
        }
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public void setEnded(boolean isEnded) {
        this.isEnded = isEnded;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    @Override
    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public boolean isMultiInstanceRoot() {
        return this.isMultiInstanceRoot;
    }

    @Override
    public void setMultiInstanceRoot(boolean isMultiInstanceRoot) {
        this.isMultiInstanceRoot = isMultiInstanceRoot;
    }

    @Override
    public boolean isCountEnabled() {
        return this.isCountEnabled;
    }

    @Override
    public void setCountEnabled(boolean isCountEnabled) {
        this.isCountEnabled = isCountEnabled;
    }

    @Override
    public String getCurrentActivityId() {
        return this.activityId;
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    @Override
    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Date getLockTime() {
        return this.lockTime;
    }

    @Override
    public void setLockTime(Date lockTime) {
        this.lockTime = lockTime;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        if (this.variableInstances != null) {
            for (String variableName : this.variableInstances.keySet()) {
                variables.put(variableName, ((VariableInstanceEntity)this.variableInstances.get(variableName)).getValue());
            }
        }
        return variables;
    }

    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getCurrentActivityName() {
        return this.activityName;
    }

    @Override
    public String getStartActivityId() {
        return this.startActivityId;
    }

    @Override
    public void setStartActivityId(String startActivityId) {
        this.startActivityId = startActivityId;
    }

    @Override
    public String getStartUserId() {
        return this.startUserId;
    }

    @Override
    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public int getEventSubscriptionCount() {
        return this.eventSubscriptionCount;
    }

    @Override
    public void setEventSubscriptionCount(int eventSubscriptionCount) {
        this.eventSubscriptionCount = eventSubscriptionCount;
    }

    @Override
    public int getTaskCount() {
        return this.taskCount;
    }

    @Override
    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    @Override
    public int getJobCount() {
        return this.jobCount;
    }

    @Override
    public void setJobCount(int jobCount) {
        this.jobCount = jobCount;
    }

    @Override
    public int getTimerJobCount() {
        return this.timerJobCount;
    }

    @Override
    public void setTimerJobCount(int timerJobCount) {
        this.timerJobCount = timerJobCount;
    }

    @Override
    public int getSuspendedJobCount() {
        return this.suspendedJobCount;
    }

    @Override
    public void setSuspendedJobCount(int suspendedJobCount) {
        this.suspendedJobCount = suspendedJobCount;
    }

    @Override
    public int getDeadLetterJobCount() {
        return this.deadLetterJobCount;
    }

    @Override
    public void setDeadLetterJobCount(int deadLetterJobCount) {
        this.deadLetterJobCount = deadLetterJobCount;
    }

    @Override
    public int getVariableCount() {
        return this.variableCount;
    }

    @Override
    public void setVariableCount(int variableCount) {
        this.variableCount = variableCount;
    }

    @Override
    public int getIdentityLinkCount() {
        return this.identityLinkCount;
    }

    @Override
    public void setIdentityLinkCount(int identityLinkCount) {
        this.identityLinkCount = identityLinkCount;
    }

    @Override
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    @Override
    public String getCallbackType() {
        return this.callbackType;
    }

    @Override
    public void setCallbackType(String callbackType) {
        this.callbackType = callbackType;
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Override
    public String getReferenceType() {
        return this.referenceType;
    }

    @Override
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    public void setPropagatedStageInstanceId(String propagatedStageInstanceId) {
        this.propagatedStageInstanceId = propagatedStageInstanceId;
    }

    @Override
    public String getPropagatedStageInstanceId() {
        return this.propagatedStageInstanceId;
    }

    protected String getRelatedActivityInstanceId(ExecutionEntity sourceExecution) {
        ActivityInstanceEntity unfinishedActivityInstance;
        String activityInstanceId = null;
        if (CommandContextUtil.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.FULL) && (unfinishedActivityInstance = CommandContextUtil.getActivityInstanceEntityManager().findUnfinishedActivityInstance(sourceExecution)) != null) {
            activityInstanceId = unfinishedActivityInstance.getId();
        }
        return activityInstanceId;
    }

    public String toString() {
        if (this.isProcessInstanceType()) {
            return "ProcessInstance[" + this.getId() + "]";
        }
        StringBuilder strb = new StringBuilder();
        if (this.isScope) {
            strb.append("Scoped execution[ id '").append(this.getId());
        } else if (this.isMultiInstanceRoot) {
            strb.append("Multi instance root execution[ id '").append(this.getId());
        } else {
            strb.append("Execution[ id '").append(this.getId());
        }
        strb.append("' ]");
        if (this.activityId != null) {
            strb.append(" - activity '").append(this.activityId).append("'");
        }
        if (this.parentId != null) {
            strb.append(" - parent '").append(this.parentId).append("'");
        }
        return strb.toString();
    }
}

