/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.impl.ModelQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.engine.impl.persistence.entity.ModelEntity;
import org.flowable.engine.impl.persistence.entity.ModelEntityManager;
import org.flowable.engine.impl.persistence.entity.data.ModelDataManager;
import org.flowable.engine.repository.Model;

public class ModelEntityManagerImpl
extends AbstractProcessEngineEntityManager<ModelEntity, ModelDataManager>
implements ModelEntityManager {
    public ModelEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, ModelDataManager modelDataManager) {
        super(processEngineConfiguration, modelDataManager);
    }

    public ModelEntity findById(String entityId) {
        return (ModelEntity)((ModelDataManager)this.dataManager).findById(entityId);
    }

    public void insert(ModelEntity model) {
        model.setCreateTime(this.getClock().getCurrentTime());
        model.setLastUpdateTime(this.getClock().getCurrentTime());
        super.insert((Entity)model);
    }

    @Override
    public void updateModel(ModelEntity updatedModel) {
        updatedModel.setLastUpdateTime(this.getClock().getCurrentTime());
        this.update(updatedModel);
    }

    public void delete(String modelId) {
        ModelEntity modelEntity = this.findById(modelId);
        super.delete((Entity)modelEntity);
        this.deleteEditorSource(modelEntity);
        this.deleteEditorSourceExtra(modelEntity);
    }

    @Override
    public void insertEditorSourceForModel(String modelId, byte[] modelSource) {
        ModelEntity model = this.findById(modelId);
        if (model != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
            ref.setValue("source", modelSource);
            if (model.getEditorSourceValueId() == null) {
                model.setEditorSourceValueId(ref.getId());
                this.updateModel(model);
            }
        }
    }

    @Override
    public void deleteEditorSource(ModelEntity model) {
        if (model.getEditorSourceValueId() != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
            ref.delete();
        }
    }

    @Override
    public void deleteEditorSourceExtra(ModelEntity model) {
        if (model.getEditorSourceExtraValueId() != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
            ref.delete();
        }
    }

    @Override
    public void insertEditorSourceExtraForModel(String modelId, byte[] modelSource) {
        ModelEntity model = this.findById(modelId);
        if (model != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
            ref.setValue("source-extra", modelSource);
            if (model.getEditorSourceExtraValueId() == null) {
                model.setEditorSourceExtraValueId(ref.getId());
                this.updateModel(model);
            }
        }
    }

    @Override
    public List<Model> findModelsByQueryCriteria(ModelQueryImpl query) {
        return ((ModelDataManager)this.dataManager).findModelsByQueryCriteria(query);
    }

    @Override
    public long findModelCountByQueryCriteria(ModelQueryImpl query) {
        return ((ModelDataManager)this.dataManager).findModelCountByQueryCriteria(query);
    }

    @Override
    public byte[] findEditorSourceByModelId(String modelId) {
        ModelEntity model = this.findById(modelId);
        if (model == null || model.getEditorSourceValueId() == null) {
            return null;
        }
        ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
        return ref.getBytes();
    }

    @Override
    public byte[] findEditorSourceExtraByModelId(String modelId) {
        ModelEntity model = this.findById(modelId);
        if (model == null || model.getEditorSourceExtraValueId() == null) {
            return null;
        }
        ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
        return ref.getBytes();
    }

    @Override
    public List<Model> findModelsByNativeQuery(Map<String, Object> parameterMap) {
        return ((ModelDataManager)this.dataManager).findModelsByNativeQuery(parameterMap);
    }

    @Override
    public long findModelCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((ModelDataManager)this.dataManager).findModelCountByNativeQuery(parameterMap);
    }
}

