/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.flowable.engine.impl.RuntimeServiceImpl;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;

public class ProcessInstanceBuilderImpl
implements ProcessInstanceBuilder {
    protected RuntimeServiceImpl runtimeService;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String messageName;
    protected String processInstanceName;
    protected String businessKey;
    protected String callbackId;
    protected String callbackType;
    protected String referenceId;
    protected String referenceType;
    protected String stageInstanceId;
    protected String tenantId;
    protected String overrideDefinitionTenantId;
    protected String predefinedProcessInstanceId;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected Map<String, Object> startFormVariables;
    protected String outcome;
    protected boolean fallbackToDefaultTenant;

    public ProcessInstanceBuilderImpl(RuntimeServiceImpl runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public ProcessInstanceBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ProcessInstanceBuilder messageName(String messageName) {
        this.messageName = messageName;
        return this;
    }

    @Override
    public ProcessInstanceBuilder name(String processInstanceName) {
        this.processInstanceName = processInstanceName;
        return this;
    }

    @Override
    public ProcessInstanceBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ProcessInstanceBuilder callbackId(String callbackId) {
        this.callbackId = callbackId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder callbackType(String callbackType) {
        this.callbackType = callbackType;
        return this;
    }

    @Override
    public ProcessInstanceBuilder referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder referenceType(String referenceType) {
        this.referenceType = referenceType;
        return this;
    }

    @Override
    public ProcessInstanceBuilder stageInstanceId(String stageInstanceId) {
        this.stageInstanceId = stageInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder overrideProcessDefinitionTenantId(String tenantId) {
        this.overrideDefinitionTenantId = tenantId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder predefineProcessInstanceId(String processInstanceId) {
        this.predefinedProcessInstanceId = processInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        if (variables != null) {
            this.variables.putAll(variables);
        }
        return this;
    }

    @Override
    public ProcessInstanceBuilder variable(String variableName, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, value);
        return this;
    }

    @Override
    public ProcessInstanceBuilder transientVariables(Map<String, Object> transientVariables) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        if (transientVariables != null) {
            this.transientVariables.putAll(transientVariables);
        }
        return this;
    }

    @Override
    public ProcessInstanceBuilder transientVariable(String variableName, Object value) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.put(variableName, value);
        return this;
    }

    @Override
    public ProcessInstanceBuilder startFormVariables(Map<String, Object> startFormVariables) {
        if (this.startFormVariables == null) {
            this.startFormVariables = new HashMap<String, Object>();
        }
        if (startFormVariables != null) {
            this.startFormVariables.putAll(startFormVariables);
        }
        return this;
    }

    @Override
    public ProcessInstanceBuilder startFormVariable(String variableName, Object value) {
        if (this.startFormVariables == null) {
            this.startFormVariables = new HashMap<String, Object>();
        }
        this.startFormVariables.put(variableName, value);
        return this;
    }

    @Override
    public ProcessInstanceBuilder outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    @Override
    public ProcessInstanceBuilder fallbackToDefaultTenant() {
        this.fallbackToDefaultTenant = true;
        return this;
    }

    @Override
    public ProcessInstance start() {
        return this.runtimeService.startProcessInstance(this);
    }

    @Override
    public ProcessInstance startAsync() {
        return this.runtimeService.startProcessInstanceAsync(this);
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public String getStageInstanceId() {
        return this.stageInstanceId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getOverrideDefinitionTenantId() {
        return this.overrideDefinitionTenantId;
    }

    public String getPredefinedProcessInstanceId() {
        return this.predefinedProcessInstanceId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, Object> getTransientVariables() {
        return this.transientVariables;
    }

    public Map<String, Object> getStartFormVariables() {
        return this.startFormVariables;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public boolean isFallbackToDefaultTenant() {
        return this.fallbackToDefaultTenant;
    }
}

