/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManagerImpl;
import org.flowable.job.service.impl.persistence.entity.data.HistoryJobDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryJobEntityManagerImpl
extends JobInfoEntityManagerImpl<HistoryJobEntity, HistoryJobDataManager>
implements HistoryJobEntityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryJobEntityManagerImpl.class);

    public HistoryJobEntityManagerImpl(JobServiceConfiguration jobServiceConfiguration, HistoryJobDataManager historyJobDataManager) {
        super(jobServiceConfiguration, historyJobDataManager);
    }

    @Override
    public List<HistoryJob> findHistoryJobsByQueryCriteria(HistoryJobQueryImpl jobQuery) {
        return ((HistoryJobDataManager)this.dataManager).findHistoryJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findHistoryJobCountByQueryCriteria(HistoryJobQueryImpl jobQuery) {
        return ((HistoryJobDataManager)this.dataManager).findHistoryJobCountByQueryCriteria(jobQuery);
    }

    public void delete(HistoryJobEntity jobEntity) {
        super.delete((Entity)jobEntity, false);
        this.deleteByteArrayRef(jobEntity.getExceptionByteArrayRef());
        this.deleteByteArrayRef(jobEntity.getAdvancedJobHandlerConfigurationByteArrayRef());
        this.deleteByteArrayRef(jobEntity.getCustomValuesByteArrayRef());
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, jobEntity));
        }
    }

    @Override
    public void deleteNoCascade(HistoryJobEntity historyJobEntity) {
        super.delete((Entity)historyJobEntity);
    }
}

