/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.job.api.ExternalWorkerJob;
import org.flowable.job.api.ExternalWorkerJobQuery;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.JobQueryProperty;

public class ExternalWorkerJobQueryImpl
extends AbstractQuery<ExternalWorkerJobQuery, ExternalWorkerJob>
implements ExternalWorkerJobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected String id;
    protected String processInstanceId;
    protected String executionId;
    protected String handlerType;
    protected String processDefinitionId;
    protected String category;
    protected String categoryLike;
    protected String elementId;
    protected String elementName;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String correlationId;
    protected Date duedateHigherThan;
    protected Date duedateLowerThan;
    protected Date duedateHigherThanOrEqual;
    protected Date duedateLowerThanOrEqual;
    protected boolean withException;
    protected String exceptionMessage;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String authorizedUser;
    protected Collection<String> authorizedGroups;
    protected String lockOwner;
    protected boolean onlyLocked;
    protected boolean onlyUnlocked;

    public ExternalWorkerJobQueryImpl() {
    }

    public ExternalWorkerJobQueryImpl(CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration) {
        super(commandContext);
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public ExternalWorkerJobQueryImpl(CommandExecutor commandExecutor, JobServiceConfiguration jobServiceConfiguration) {
        super(commandExecutor);
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public ExternalWorkerJobQuery jobId(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    public ExternalWorkerJobQuery processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public ExternalWorkerJobQuery processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public ExternalWorkerJobQuery category(String category) {
        if (category == null) {
            throw new FlowableIllegalArgumentException("Provided category is null");
        }
        this.category = category;
        return this;
    }

    public ExternalWorkerJobQuery categoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new FlowableIllegalArgumentException("Provided categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    public ExternalWorkerJobQuery elementId(String elementId) {
        if (elementId == null) {
            throw new FlowableIllegalArgumentException("Provided element id is null");
        }
        this.elementId = elementId;
        return this;
    }

    public ExternalWorkerJobQuery elementName(String elementName) {
        if (elementName == null) {
            throw new FlowableIllegalArgumentException("Provided element name is null");
        }
        this.elementName = elementName;
        return this;
    }

    public ExternalWorkerJobQueryImpl scopeId(String scopeId) {
        if (scopeId == null) {
            throw new FlowableIllegalArgumentException("Provided scope id is null");
        }
        this.scopeId = scopeId;
        return this;
    }

    public ExternalWorkerJobQuery subScopeId(String subScopeId) {
        if (subScopeId == null) {
            throw new FlowableIllegalArgumentException("Provided sub scope id is null");
        }
        this.subScopeId = subScopeId;
        return this;
    }

    public ExternalWorkerJobQueryImpl scopeType(String scopeType) {
        if (scopeType == null) {
            throw new FlowableIllegalArgumentException("Provided scope type is null");
        }
        this.scopeType = scopeType;
        return this;
    }

    public ExternalWorkerJobQuery scopeDefinitionId(String scopeDefinitionId) {
        if (scopeDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided scope definitionid is null");
        }
        this.scopeDefinitionId = scopeDefinitionId;
        return this;
    }

    public ExternalWorkerJobQuery caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided case instance id is null");
        }
        this.scopeId(caseInstanceId);
        this.scopeType("cmmn");
        return this;
    }

    public ExternalWorkerJobQuery caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided case definition id is null");
        }
        this.scopeDefinitionId(caseDefinitionId);
        this.scopeType("cmmn");
        return this;
    }

    public ExternalWorkerJobQuery planItemInstanceId(String planItemInstanceId) {
        if (planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided plan item instance id is null");
        }
        this.subScopeId(planItemInstanceId);
        this.scopeType("cmmn");
        return this;
    }

    public ExternalWorkerJobQuery correlationId(String correlationId) {
        if (correlationId == null) {
            throw new FlowableIllegalArgumentException("Provided correlationId is null");
        }
        this.correlationId = correlationId;
        return this;
    }

    public ExternalWorkerJobQuery executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    public ExternalWorkerJobQuery handlerType(String handlerType) {
        if (handlerType == null) {
            throw new FlowableIllegalArgumentException("Provided handlerType is null");
        }
        this.handlerType = handlerType;
        return this;
    }

    public ExternalWorkerJobQuery duedateHigherThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateHigherThan = date;
        return this;
    }

    public ExternalWorkerJobQuery duedateLowerThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateLowerThan = date;
        return this;
    }

    public ExternalWorkerJobQuery withException() {
        this.withException = true;
        return this;
    }

    public ExternalWorkerJobQuery exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new FlowableIllegalArgumentException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    public ExternalWorkerJobQuery jobTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public ExternalWorkerJobQuery jobTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public ExternalWorkerJobQuery jobWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public ExternalWorkerJobQuery forUserOrGroups(String userId, Collection<String> groups) {
        if (userId == null && (groups == null || groups.isEmpty())) {
            throw new FlowableIllegalArgumentException("at least one of userId or groups must be provided");
        }
        this.authorizedUser = userId;
        this.authorizedGroups = groups;
        return this;
    }

    public ExternalWorkerJobQuery lockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
        return this;
    }

    public ExternalWorkerJobQuery locked() {
        this.onlyLocked = true;
        return this;
    }

    public ExternalWorkerJobQuery unlocked() {
        this.onlyUnlocked = true;
        return this;
    }

    public ExternalWorkerJobQuery orderByJobDuedate() {
        return (ExternalWorkerJobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    public ExternalWorkerJobQuery orderByExecutionId() {
        return (ExternalWorkerJobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    public ExternalWorkerJobQuery orderByJobId() {
        return (ExternalWorkerJobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    public ExternalWorkerJobQuery orderByProcessInstanceId() {
        return (ExternalWorkerJobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    public ExternalWorkerJobQuery orderByJobRetries() {
        return (ExternalWorkerJobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    public ExternalWorkerJobQuery orderByTenantId() {
        return (ExternalWorkerJobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return this.jobServiceConfiguration.getExternalWorkerJobEntityManager().findJobCountByQueryCriteria(this);
    }

    public List<ExternalWorkerJob> executeList(CommandContext commandContext) {
        return this.jobServiceConfiguration.getExternalWorkerJobEntityManager().findJobsByQueryCriteria(this);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public Date getNow() {
        return this.jobServiceConfiguration.getClock().getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getAuthorizedUser() {
        return this.authorizedUser;
    }

    public Collection<String> getAuthorizedGroups() {
        return this.authorizedGroups;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Date getDuedateHigherThan() {
        return this.duedateHigherThan;
    }

    public Date getDuedateLowerThan() {
        return this.duedateLowerThan;
    }

    public Date getDuedateHigherThanOrEqual() {
        return this.duedateHigherThanOrEqual;
    }

    public Date getDuedateLowerThanOrEqual() {
        return this.duedateLowerThanOrEqual;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public boolean isOnlyLocked() {
        return this.onlyLocked;
    }

    public boolean isOnlyUnlocked() {
        return this.onlyUnlocked;
    }
}

