/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistoryListener;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class DefaultAsyncHistoryJobProducer
implements AsyncHistoryListener {
    @Override
    public List<HistoryJobEntity> historyDataGenerated(JobServiceConfiguration jobServiceConfiguration, List<ObjectNode> historyObjectNodes) {
        CommandContext commandContext = Context.getCommandContext();
        List<HistoryJobEntity> historyJobEntities = this.createJobsWithHistoricalData(commandContext, jobServiceConfiguration, historyObjectNodes);
        this.processHistoryJobEntities(commandContext, jobServiceConfiguration, historyObjectNodes, historyJobEntities);
        this.scheduleJobs(commandContext, jobServiceConfiguration, historyJobEntities);
        return historyJobEntities;
    }

    protected List<HistoryJobEntity> createJobsWithHistoricalData(CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration, List<ObjectNode> historyObjectNodes) {
        AsyncHistorySession asyncHistorySession = (AsyncHistorySession)commandContext.getSession(AsyncHistorySession.class);
        if (jobServiceConfiguration.isAsyncHistoryJsonGroupingEnabled() && historyObjectNodes.size() >= jobServiceConfiguration.getAsyncHistoryJsonGroupingThreshold()) {
            String jobType = this.getJobType(jobServiceConfiguration, true);
            HistoryJobEntity jobEntity = this.createJob(commandContext, asyncHistorySession, jobServiceConfiguration, jobType);
            ArrayNode arrayNode = jobServiceConfiguration.getObjectMapper().createArrayNode();
            for (ObjectNode historyJsonNode : historyObjectNodes) {
                arrayNode.add((JsonNode)historyJsonNode);
            }
            this.addJsonToJob(commandContext, jobServiceConfiguration, jobEntity, (JsonNode)arrayNode, jobServiceConfiguration.isAsyncHistoryJsonGzipCompressionEnabled());
            return Collections.singletonList(jobEntity);
        }
        ArrayList<HistoryJobEntity> historyJobEntities = new ArrayList<HistoryJobEntity>(historyObjectNodes.size());
        String jobType = this.getJobType(jobServiceConfiguration, false);
        for (ObjectNode historyJsonNode : historyObjectNodes) {
            HistoryJobEntity jobEntity = this.createJob(commandContext, asyncHistorySession, jobServiceConfiguration, jobType);
            this.addJsonToJob(commandContext, jobServiceConfiguration, jobEntity, (JsonNode)historyJsonNode, false);
            historyJobEntities.add(jobEntity);
        }
        return historyJobEntities;
    }

    protected HistoryJobEntity createJob(CommandContext commandContext, AsyncHistorySession asyncHistorySession, JobServiceConfiguration jobServiceConfiguration, String jobType) {
        HistoryJobEntity currentJobEntity = (HistoryJobEntity)jobServiceConfiguration.getHistoryJobEntityManager().create();
        currentJobEntity.setJobHandlerType(jobType);
        currentJobEntity.setRetries(jobServiceConfiguration.getAsyncHistoryExecutorNumberOfRetries());
        currentJobEntity.setTenantId(asyncHistorySession.getTenantId());
        currentJobEntity.setCreateTime(jobServiceConfiguration.getClock().getCurrentTime());
        currentJobEntity.setScopeType(jobServiceConfiguration.getHistoryJobExecutionScope());
        return currentJobEntity;
    }

    protected void scheduleJobs(CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration, List<HistoryJobEntity> historyJobEntities) {
        for (HistoryJobEntity historyJobEntity : historyJobEntities) {
            jobServiceConfiguration.getJobManager().scheduleHistoryJob(historyJobEntity);
        }
    }

    protected void addJsonToJob(CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration, HistoryJobEntity jobEntity, JsonNode rootObjectNode, boolean applyCompression) {
        try {
            byte[] bytes = jobServiceConfiguration.getObjectMapper().writeValueAsBytes((Object)rootObjectNode);
            if (applyCompression) {
                bytes = this.compress(bytes);
            }
            jobEntity.setAdvancedJobHandlerConfigurationBytes(bytes);
        }
        catch (JsonProcessingException e) {
            throw new FlowableException("Could not serialize historic data for async history", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] compress(byte[] bytes) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
                gos.write(bytes);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new FlowableException("Error while compressing json", (Throwable)e);
        }
    }

    protected String getJobType(JobServiceConfiguration jobServiceConfiguration, boolean groupingEnabled) {
        if (groupingEnabled) {
            return jobServiceConfiguration.isAsyncHistoryJsonGzipCompressionEnabled() ? jobServiceConfiguration.getJobTypeAsyncHistoryZipped() : jobServiceConfiguration.getJobTypeAsyncHistory();
        }
        return jobServiceConfiguration.getJobTypeAsyncHistory();
    }

    protected void processHistoryJobEntities(CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration, List<ObjectNode> historyObjectNodes, List<HistoryJobEntity> historyJobEntities) {
    }
}

