/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity.data.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.db.SingleCachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.job.api.ExternalWorkerJob;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.ExternalWorkerJobAcquireBuilderImpl;
import org.flowable.job.service.impl.ExternalWorkerJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityImpl;
import org.flowable.job.service.impl.persistence.entity.data.ExternalWorkerJobDataManager;
import org.flowable.job.service.impl.persistence.entity.data.impl.cachematcher.ExternalWorkerJobsByExecutionIdMatcher;
import org.flowable.job.service.impl.persistence.entity.data.impl.cachematcher.ExternalWorkerJobsByScopeIdAndSubScopeIdMatcher;
import org.flowable.job.service.impl.persistence.entity.data.impl.cachematcher.JobByCorrelationIdMatcher;

public class MybatisExternalWorkerJobDataManager
extends AbstractDataManager<ExternalWorkerJobEntity>
implements ExternalWorkerJobDataManager {
    protected JobServiceConfiguration jobServiceConfiguration;
    protected CachedEntityMatcher<ExternalWorkerJobEntity> jobsByExecutionIdMatcher = new ExternalWorkerJobsByExecutionIdMatcher();
    protected CachedEntityMatcher<ExternalWorkerJobEntity> externalWorkerJobsByScopeIdAndSubScopeIdMatcher = new ExternalWorkerJobsByScopeIdAndSubScopeIdMatcher();
    protected SingleCachedEntityMatcher<ExternalWorkerJobEntity> externalWorkerJobByCorrelationIdMatcher = new JobByCorrelationIdMatcher<ExternalWorkerJobEntity>();

    public MybatisExternalWorkerJobDataManager(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Class<? extends ExternalWorkerJobEntity> getManagedEntityClass() {
        return ExternalWorkerJobEntityImpl.class;
    }

    public ExternalWorkerJobEntity create() {
        return new ExternalWorkerJobEntityImpl();
    }

    @Override
    public ExternalWorkerJobEntity findJobByCorrelationId(String correlationId) {
        return (ExternalWorkerJobEntity)this.getEntity("selectExternalWorkerJobByCorrelationId", correlationId, this.externalWorkerJobByCorrelationIdMatcher, true);
    }

    @Override
    public List<ExternalWorkerJobEntity> findJobsToExecute(List<String> enabledCategories, Page page) {
        throw new FlowableException("Use dedicated method for finding external worker jobs to execute");
    }

    @Override
    public List<ExternalWorkerJobEntity> findJobsByExecutionId(String executionId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", executionId)) {
            return this.getListFromCache(this.jobsByExecutionIdMatcher, executionId);
        }
        return this.getList(dbSqlSession, "selectExternalWorkerJobsByExecutionId", executionId, this.jobsByExecutionIdMatcher, true);
    }

    @Override
    public List<ExternalWorkerJobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectExternalWorkerJobsByProcessInstanceId", (Object)processInstanceId);
    }

    @Override
    public List<ExternalWorkerJobEntity> findExpiredJobs(List<String> enabledCategories, Page page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobExecutionScope", this.jobServiceConfiguration.getJobExecutionScope());
        Date now = this.jobServiceConfiguration.getClock().getCurrentTime();
        params.put("now", now);
        if (enabledCategories != null && enabledCategories.size() > 0) {
            params.put("enabledCategories", enabledCategories);
        }
        return this.getDbSqlSession().selectList("selectExpiredExternalWorkerJobs", params, page);
    }

    @Override
    public List<ExternalWorkerJob> findJobsByQueryCriteria(ExternalWorkerJobQueryImpl jobQuery) {
        String query = "selectExternalWorkerJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectExternalWorkerJobByQueryCriteria", (ListQueryParameterObject)jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(ExternalWorkerJobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectExternalWorkerJobCountByQueryCriteria", (Object)jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateExternalWorkerJobTenantIdForDeployment", params);
    }

    @Override
    public void resetExpiredJob(String jobId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", jobId);
        params.put("now", this.jobServiceConfiguration.getClock().getCurrentTime());
        this.getDbSqlSession().update("resetExpiredExternalWorkerJob", params);
    }

    @Override
    public void deleteJobsByExecutionId(String executionId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", executionId)) {
            this.deleteCachedEntities(dbSqlSession, this.jobsByExecutionIdMatcher, executionId);
        } else {
            this.bulkDelete("deleteExternalWorkerJobsByExecutionId", this.jobsByExecutionIdMatcher, executionId);
        }
    }

    @Override
    public List<ExternalWorkerJobEntity> findExternalJobsToExecute(ExternalWorkerJobAcquireBuilderImpl builder, int numberOfJobs) {
        return this.getDbSqlSession().selectList("selectExternalWorkerJobsToExecute", (Object)builder, new Page(0, numberOfJobs));
    }

    @Override
    public List<ExternalWorkerJobEntity> findJobsByScopeIdAndSubScopeId(String scopeId, String subScopeId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("scopeId", scopeId);
        paramMap.put("subScopeId", subScopeId);
        return this.getList(this.getDbSqlSession(), "selectExternalWorkerJobsByScopeIdAndSubScopeId", paramMap, this.externalWorkerJobsByScopeIdAndSubScopeIdMatcher, true);
    }

    protected IdGenerator getIdGenerator() {
        return this.jobServiceConfiguration.getIdGenerator();
    }
}

