/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.job.api.ExternalWorkerJob;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.ExternalWorkerJobAcquireBuilderImpl;
import org.flowable.job.service.impl.ExternalWorkerJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManagerImpl;
import org.flowable.job.service.impl.persistence.entity.data.ExternalWorkerJobDataManager;

public class ExternalWorkerJobEntityManagerImpl
extends JobInfoEntityManagerImpl<ExternalWorkerJobEntity, ExternalWorkerJobDataManager>
implements ExternalWorkerJobEntityManager {
    public ExternalWorkerJobEntityManagerImpl(JobServiceConfiguration jobServiceConfiguration, ExternalWorkerJobDataManager jobDataManager) {
        super(jobServiceConfiguration, jobDataManager);
    }

    @Override
    public boolean insertExternalWorkerJobEntity(ExternalWorkerJobEntity jobEntity) {
        return this.doInsert(jobEntity, true);
    }

    public void insert(ExternalWorkerJobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(ExternalWorkerJobEntity jobEntity, boolean fireCreateEvent) {
        boolean handledJob;
        if (((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager() != null && !(handledJob = ((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager().handleJobInsert(jobEntity))) {
            return false;
        }
        jobEntity.setCreateTime(this.getClock().getCurrentTime());
        if (jobEntity.getCorrelationId() == null) {
            jobEntity.setCorrelationId(((JobServiceConfiguration)this.serviceConfiguration).getIdGenerator().getNextId());
        }
        super.insert((Entity)jobEntity, fireCreateEvent);
        return true;
    }

    @Override
    public ExternalWorkerJobEntity findJobByCorrelationId(String correlationId) {
        return ((ExternalWorkerJobDataManager)this.dataManager).findJobByCorrelationId(correlationId);
    }

    @Override
    public List<ExternalWorkerJobEntity> findJobsByScopeIdAndSubScopeId(String scopeId, String subScopeId) {
        return ((ExternalWorkerJobDataManager)this.dataManager).findJobsByScopeIdAndSubScopeId(scopeId, subScopeId);
    }

    @Override
    public List<ExternalWorkerJobEntity> findJobsByWorkerId(String workerId) {
        return ((ExternalWorkerJobDataManager)this.dataManager).findJobsByWorkerId(workerId);
    }

    @Override
    public List<ExternalWorkerJobEntity> findJobsByWorkerIdAndTenantId(String workerId, String tenantId) {
        return ((ExternalWorkerJobDataManager)this.dataManager).findJobsByWorkerIdAndTenantId(workerId, tenantId);
    }

    @Override
    public List<ExternalWorkerJob> findJobsByQueryCriteria(ExternalWorkerJobQueryImpl jobQuery) {
        return ((ExternalWorkerJobDataManager)this.dataManager).findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(ExternalWorkerJobQueryImpl jobQuery) {
        return ((ExternalWorkerJobDataManager)this.dataManager).findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public List<ExternalWorkerJobEntity> findExternalJobsToExecute(ExternalWorkerJobAcquireBuilderImpl builder, int numberOfJobs) {
        return ((ExternalWorkerJobDataManager)this.dataManager).findExternalJobsToExecute(builder, numberOfJobs);
    }

    public void delete(ExternalWorkerJobEntity entity, boolean fireDeleteEvent) {
        this.deleteByteArrayRef(entity.getExceptionByteArrayRef());
        this.deleteByteArrayRef(entity.getCustomValuesByteArrayRef());
        if (((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager() != null) {
            ((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager().handleJobDelete(entity);
        }
        super.delete((Entity)entity, fireDeleteEvent);
    }
}

