/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.HttpServiceTask;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;

public class HttpTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        HttpTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        HttpTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("HttpTask", HttpTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "HttpTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        HttpServiceTask task = new HttpServiceTask();
        task.setType("http");
        String parallelInSameTransaction = this.getPropertyValueAsString("httptaskparallelinsametransaction", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)parallelInSameTransaction)) {
            task.setParallelInSameTransaction(Boolean.valueOf(Boolean.parseBoolean(parallelInSameTransaction)));
        }
        this.addField("requestMethod", "httptaskrequestmethod", "GET", elementNode, (ServiceTask)task);
        this.addField("requestUrl", "httptaskrequesturl", elementNode, (ServiceTask)task);
        this.addField("requestHeaders", "httptaskrequestheaders", elementNode, (ServiceTask)task);
        this.addField("requestBody", "httptaskrequestbody", elementNode, (ServiceTask)task);
        this.addField("requestBodyEncoding", "httptaskrequestbodyencoding", elementNode, (ServiceTask)task);
        this.addField("requestTimeout", "httptaskrequesttimeout", elementNode, (ServiceTask)task);
        this.addField("disallowRedirects", "httptaskdisallowredirects", elementNode, (ServiceTask)task);
        this.addField("failStatusCodes", "httptaskfailstatuscodes", elementNode, (ServiceTask)task);
        this.addField("handleStatusCodes", "httptaskhandlestatuscodes", elementNode, (ServiceTask)task);
        this.addField("responseVariableName", "httptaskresponsevariablename", elementNode, (ServiceTask)task);
        this.addField("ignoreException", "httptaskignoreexception", elementNode, (ServiceTask)task);
        this.addField("saveRequestVariables", "httptasksaverequestvariables", elementNode, (ServiceTask)task);
        this.addField("saveResponseParameters", "httptasksaveresponseparameters", elementNode, (ServiceTask)task);
        this.addField("resultVariablePrefix", "httptaskresultvariableprefix", elementNode, (ServiceTask)task);
        this.addField("saveResponseParametersTransient", "httptasksaveresponseparameterstransient", elementNode, (ServiceTask)task);
        this.addField("saveResponseVariableAsJson", "httptasksaveresponseasjson", elementNode, (ServiceTask)task);
        task.setSkipExpression(this.getPropertyValueAsString("skipexpression", elementNode));
        return task;
    }
}

