/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ProxyCtl;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.internal.ServiceLocatorImpl;

public class MethodInterceptorImpl
implements MethodHandler {
    private static final String PROXY_MORE_METHOD_NAME = "__make";
    private final ServiceLocatorImpl locator;
    private final ActiveDescriptor<?> descriptor;
    private final ServiceHandle<?> root;
    private static final String EQUALS_NAME = "equals";

    MethodInterceptorImpl(ServiceLocatorImpl sli, ActiveDescriptor<?> descriptor, ServiceHandle<?> root) {
        this.locator = sli;
        this.descriptor = descriptor;
        this.root = root;
    }

    public Object invoke(Object target, Method method, Method proceed, Object[] params) throws Throwable {
        Context<?> context = this.locator.resolveContext(this.descriptor.getScopeAnnotation());
        Object service = context.findOrCreate(this.descriptor, this.root);
        if (service == null) {
            throw new MultiException((Throwable)new IllegalStateException("Proxiable context " + context + " findOrCreate returned a null for descriptor " + this.descriptor + " and handle " + this.root));
        }
        if (method.getName().equals(PROXY_MORE_METHOD_NAME)) {
            return service;
        }
        if (MethodInterceptorImpl.isEquals(method) && params.length == 1 && params[0] != null && params[0] instanceof ProxyCtl) {
            ProxyCtl equalsProxy = (ProxyCtl)params[0];
            params = new Object[]{equalsProxy.__make()};
        }
        return ReflectionHelper.invoke((Object)service, (Method)method, (Object[])params, (boolean)this.locator.getNeutralContextClassLoader());
    }

    private static boolean isEquals(Method m) {
        if (!m.getName().equals(EQUALS_NAME)) {
            return false;
        }
        Class<?>[] params = m.getParameterTypes();
        if (params == null || params.length != 1) {
            return false;
        }
        return Object.class.equals(params[0]);
    }
}

