/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.LobStore;

public class LobStoreMem
implements LobStore {
    final int lobBlockSize;
    int blocksInLargeBlock = 128;
    int largeBlockSize;
    HsqlArrayList byteStoreList;

    public LobStoreMem(int n) {
        this.lobBlockSize = n;
        this.largeBlockSize = n * this.blocksInLargeBlock;
        this.byteStoreList = new HsqlArrayList();
    }

    public byte[] getBlockBytes(int n, int n2) {
        byte[] byArray = new byte[n2 * this.lobBlockSize];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = n / this.blocksInLargeBlock;
            byte[] byArray2 = (byte[])this.byteStoreList.get(n4);
            int n5 = n % this.blocksInLargeBlock;
            int n6 = n2;
            if (n5 + n6 > this.blocksInLargeBlock) {
                n6 = this.blocksInLargeBlock - n5;
            }
            System.arraycopy(byArray2, n5 * this.lobBlockSize, byArray, n3 * this.lobBlockSize, n6 * this.lobBlockSize);
            n += n6;
            n3 += n6;
            n2 -= n6;
        }
        return byArray;
    }

    public void setBlockBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = n / this.blocksInLargeBlock;
            int n5 = (n + n2) / this.blocksInLargeBlock;
            if ((n + n2) % this.blocksInLargeBlock != 0) {
                ++n5;
            }
            if (n4 >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] byArray2 = (byte[])this.byteStoreList.get(n4);
            int n6 = n % this.blocksInLargeBlock;
            int n7 = n2;
            if (n6 + n7 > this.blocksInLargeBlock) {
                n7 = this.blocksInLargeBlock - n6;
            }
            System.arraycopy(byArray, n3 * this.lobBlockSize, byArray2, n6 * this.lobBlockSize, n7 * this.lobBlockSize);
            n += n7;
            n3 += n7;
            n2 -= n7;
        }
    }

    public int getBlockSize() {
        return this.lobBlockSize;
    }

    public void close() {
        this.byteStoreList.clear();
    }
}

