/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isClosed;
    boolean isDump;
    boolean includeCachedData;
    long byteCount;
    volatile boolean needsSync;
    volatile boolean forceSync;
    volatile boolean busyWriting;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    ScriptWriterBase(Database database, String string, boolean bl, boolean bl2, boolean bl3) {
        this.isDump = bl3;
        this.initBuffers();
        boolean bl4 = false;
        bl4 = bl3 ? FileUtil.getFileUtil().exists(string) : database.logger.getFileAccess().isStreamElement(string);
        if (bl4 && bl2) {
            throw Error.error(452, string);
        }
        this.database = database;
        this.includeCachedData = bl;
        this.outFile = string;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void reopen() {
        this.openFile();
    }

    protected abstract void initBuffers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.isClosed) {
            return;
        }
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            if (this.needsSync) {
                if (this.busyWriting) {
                    this.forceSync = true;
                    return;
                }
                try {
                    this.fileStreamOut.flush();
                    this.outDescriptor.sync();
                    ++this.syncCount;
                }
                catch (IOException iOException) {
                    Error.printSystemOut("flush() or sync() error: " + iOException.toString());
                }
                this.needsSync = false;
                this.forceSync = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forceSync() {
        if (this.isClosed) {
            return;
        }
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException iOException) {
                Error.printSystemOut("flush() or sync() error: " + iOException.toString());
            }
            this.needsSync = false;
            this.forceSync = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stop();
        if (this.isClosed) {
            return;
        }
        try {
            OutputStream outputStream = this.fileStreamOut;
            synchronized (outputStream) {
                this.needsSync = false;
                this.isClosed = true;
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                this.fileStreamOut.close();
            }
        }
        catch (IOException iOException) {
            throw Error.error(452);
        }
        this.byteCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() {
        try {
            this.writeDDL();
            this.writeExistingData();
            this.finishStream();
        }
        catch (IOException iOException) {
            throw Error.error(452);
        }
    }

    protected void openFile() {
        try {
            FileUtil fileUtil = this.isDump ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream outputStream = fileUtil.openOutputStreamElement(this.outFile);
            this.outDescriptor = fileUtil.getFileSync(outputStream);
            this.fileStreamOut = new BufferedOutputStream(outputStream, 8192);
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, 26, new Object[]{iOException.getMessage(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL() throws IOException {
        Result result = this.database.getScript(!this.includeCachedData);
        this.writeSingleColumnResult(result);
    }

    protected void writeExistingData() throws IOException {
        this.currentSession.loggedSchema = null;
        Iterator iterator = this.database.schemaManager.allSchemaNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.database.schemaManager.databaseObjectIterator(string, 3);
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                boolean bl = false;
                switch (table.getTableType()) {
                    case 4: {
                        bl = true;
                        break;
                    }
                    case 5: {
                        bl = this.includeCachedData;
                        break;
                    }
                    case 7: {
                        bl = this.includeCachedData && !table.isReadOnly();
                    }
                }
                try {
                    if (!bl) continue;
                    this.schemaToLog = table.getName().schema;
                    this.writeTableInit(table);
                    RowIterator rowIterator = table.rowIterator(this.currentSession);
                    while (rowIterator.hasNext()) {
                        this.writeRow(this.currentSession, table, rowIterator.getNextRow().getData());
                    }
                    this.writeTableTerm(table);
                }
                catch (Exception exception) {
                    throw Error.error(452, exception.toString());
                }
            }
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Table table) throws IOException {
    }

    protected void writeTableTerm(Table table) throws IOException {
    }

    protected void writeSingleColumnResult(Result result) throws IOException {
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        while (rowSetNavigator.hasNext()) {
            Object[] objectArray = rowSetNavigator.getNext();
            this.writeLogStatement(this.currentSession, (String)objectArray[0]);
        }
    }

    abstract void writeRow(Session var1, Table var2, Object[] var3) throws IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void writeSessionIdAndSchema(Session var1) throws IOException;

    public abstract void writeLogStatement(Session var1, String var2) throws IOException;

    public abstract void writeInsertStatement(Session var1, Table var2, Object[] var3) throws IOException;

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3) throws IOException;

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2) throws IOException;

    public abstract void writeCommitStatement(Session var1) throws IOException;

    public void run() {
        try {
            if (this.writeDelay != 0) {
                this.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    public void start() {
        if (this.writeDelay > 0) {
            this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, this.writeDelay, this, false);
        }
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

