/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.jpa;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.hswebframework.ezorm.core.DefaultValueGenerator;
import org.hswebframework.ezorm.rdb.codec.EnumValueCodec;
import org.hswebframework.ezorm.rdb.mapping.DefaultEntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.jpa.SimpleEntityPropertyDescriptor;
import org.hswebframework.ezorm.rdb.mapping.parser.DataTypeResolver;
import org.hswebframework.ezorm.rdb.mapping.parser.ValueCodecResolver;
import org.hswebframework.ezorm.rdb.metadata.LazyDefaultValueGenerator;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.ValueCodecFactory;
import org.hswebframework.ezorm.rdb.metadata.key.AssociationType;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.EnumFragmentBuilder;
import org.hswebframework.ezorm.rdb.utils.AnnotationUtils;
import org.hswebframework.ezorm.rdb.utils.PropertiesUtils;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaEntityTableMetadataParserProcessor {
    private static final Logger log = LoggerFactory.getLogger(JpaEntityTableMetadataParserProcessor.class);
    private final DefaultEntityColumnMapping mapping;
    private final Class<?> entityType;
    private final RDBTableMetadata tableMetadata;
    private DataTypeResolver dataTypeResolver;
    private ValueCodecResolver valueCodecResolver;

    public JpaEntityTableMetadataParserProcessor(RDBTableMetadata tableMetadata, Class<?> entityType) {
        this.tableMetadata = tableMetadata;
        this.entityType = entityType;
        this.mapping = new DefaultEntityColumnMapping(tableMetadata, entityType);
        tableMetadata.addFeature(this.mapping);
    }

    public void process() {
        PropertyDescriptor[] descriptors = BeanUtilsBean.getInstance().getPropertyUtils().getPropertyDescriptors(this.entityType);
        Table table = (Table)ClassUtils.getAnnotation(this.entityType, Table.class);
        int idx = 0;
        for (Index index : table.indexes()) {
            String[] columnList;
            String name = index.name();
            if (name.isEmpty()) {
                name = this.tableMetadata.getName().concat("_idx_").concat(String.valueOf(idx++));
            }
            RDBIndexMetadata indexMetadata = new RDBIndexMetadata();
            indexMetadata.setUnique(index.unique());
            indexMetadata.setName(name);
            for (String str : columnList = index.columnList().split("[,]")) {
                String[] columnAndSort = str.split("[ ]+");
                RDBIndexMetadata.IndexColumn column2 = new RDBIndexMetadata.IndexColumn();
                column2.setColumn(columnAndSort[0].trim());
                if (columnAndSort.length > 1) {
                    column2.setSort(columnAndSort[1].equalsIgnoreCase("desc") ? RDBIndexMetadata.IndexSort.desc : RDBIndexMetadata.IndexSort.asc);
                }
                indexMetadata.getColumns().add(column2);
            }
            this.tableMetadata.addIndex(indexMetadata);
        }
        ArrayList afterRun = new ArrayList();
        for (PropertyDescriptor descriptor : descriptors) {
            Set<Annotation> annotations = AnnotationUtils.getAnnotations(this.entityType, descriptor);
            this.getAnnotation(annotations, Column.class).ifPresent(column -> this.handleColumnAnnotation(descriptor, annotations, ColumnInfo.of(column)));
            this.getAnnotation(annotations, JoinColumns.class).ifPresent(column -> afterRun.add(() -> this.handleJoinColumnAnnotation(descriptor, annotations, column.value())));
            this.getAnnotation(annotations, JoinColumn.class).ifPresent(column -> afterRun.add(() -> this.handleJoinColumnAnnotation(descriptor, annotations, (JoinColumn)column)));
        }
        afterRun.forEach(Runnable::run);
    }

    private <T extends Annotation> Optional<T> getAnnotation(Set<Annotation> annotations, Class<T> type) {
        return annotations.stream().filter(type::isInstance).map(type::cast).findFirst();
    }

    private void handleJoinColumnAnnotation(PropertyDescriptor descriptor, Set<Annotation> annotations, JoinTable column) {
    }

    private void handleJoinColumnAnnotation(PropertyDescriptor descriptor, Set<Annotation> annotations, JoinColumn ... column) {
        Table join;
        Field field = PropertiesUtils.getPropertyField(this.entityType, descriptor.getName()).orElseThrow(() -> new NoSuchFieldException("no such field " + descriptor.getName() + " in " + this.entityType));
        ForeignKeyBuilder builder = ForeignKeyBuilder.builder().source(this.tableMetadata.getFullName()).name(descriptor.getName()).alias(descriptor.getName()).build();
        Type fieldGenericType = field.getGenericType();
        if (fieldGenericType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)fieldGenericType).getActualTypeArguments();
            join = Stream.of(types).map(Class.class::cast).map(t -> AnnotationUtils.getAnnotation(t, Table.class)).filter(Objects::nonNull).findFirst().orElse(null);
        } else {
            builder.setAutoJoin(true);
            join = AnnotationUtils.getAnnotation(field.getType(), Table.class);
        }
        if (join == null) {
            log.warn("can not resolve join table for :{}", (Object)field);
            return;
        }
        String joinTableName = join.schema().isEmpty() ? join.name() : join.schema().concat(".").concat(join.name());
        builder.setTarget(joinTableName);
        this.getAnnotation(annotations, OneToOne.class).ifPresent(oneToOne -> builder.setAssociationType(AssociationType.oneToOne));
        this.getAnnotation(annotations, OneToMany.class).ifPresent(oneToOne -> builder.setAssociationType(AssociationType.oneToMay));
        this.getAnnotation(annotations, ManyToMany.class).ifPresent(oneToOne -> builder.setAssociationType(AssociationType.manyToMay));
        this.getAnnotation(annotations, ManyToOne.class).ifPresent(oneToOne -> builder.setAssociationType(AssociationType.manyToOne));
        for (JoinColumn joinColumn : column) {
            String columnName = joinColumn.name();
            builder.addColumn(columnName, joinColumn.referencedColumnName());
        }
        this.tableMetadata.addForeignKey(builder);
    }

    private void handleColumnAnnotation(PropertyDescriptor descriptor, Set<Annotation> annotations, ColumnInfo column) {
        if (!column.table.isEmpty() && !column.table.equals(this.tableMetadata.getName())) {
            this.mapping.addMapping(column.table.concat(".").concat(column.name), descriptor.getName());
            return;
        }
        String columnName = !column.name.isEmpty() ? column.name : StringUtils.camelCase2UnderScoreCase((String)descriptor.getName());
        Class<?> javaType = descriptor.getPropertyType();
        if (javaType == Object.class) {
            javaType = descriptor.getReadMethod().getReturnType();
        }
        this.mapping.addMapping(columnName, descriptor.getName());
        RDBColumnMetadata metadata = this.tableMetadata.getColumn(columnName).orElseGet(this.tableMetadata::newColumn);
        metadata.setName(columnName);
        metadata.setAlias(descriptor.getName());
        metadata.setJavaType(javaType);
        metadata.setLength(column.length);
        metadata.setPrecision(column.precision);
        metadata.setScale(column.scale);
        metadata.setNotNull(!column.nullable);
        metadata.setUpdatable(column.updatable);
        metadata.setInsertable(column.insertable);
        if (!column.columnDefinition.isEmpty()) {
            metadata.setColumnDefinition(column.columnDefinition);
        }
        this.getAnnotation(annotations, GeneratedValue.class).map(GeneratedValue::generator).map(gen -> LazyDefaultValueGenerator.of(() -> (DefaultValueGenerator)this.tableMetadata.findFeatureNow(DefaultValueGenerator.createId((String)gen)))).map(gen -> gen.generate(metadata)).ifPresent(arg_0 -> ((RDBColumnMetadata)metadata).setDefaultValue(arg_0));
        this.getAnnotation(annotations, DefaultValue.class).map(gen -> {
            if (gen.value().isEmpty()) {
                return LazyDefaultValueGenerator.of(() -> (DefaultValueGenerator)this.tableMetadata.findFeatureNow(DefaultValueGenerator.createId((String)gen.generator()))).generate(metadata);
            }
            return gen::value;
        }).ifPresent(arg_0 -> ((RDBColumnMetadata)metadata).setDefaultValue(arg_0));
        this.getAnnotation(annotations, Comment.class).map(Comment::value).ifPresent(arg_0 -> ((RDBColumnMetadata)metadata).setComment(arg_0));
        this.getAnnotation(annotations, Id.class).ifPresent(id -> metadata.setPrimaryKey(true));
        SimpleEntityPropertyDescriptor propertyDescriptor = SimpleEntityPropertyDescriptor.of(this.entityType, descriptor.getName(), javaType, metadata, descriptor);
        metadata.addFeature(propertyDescriptor);
        Optional.ofNullable(this.dataTypeResolver).map(resolver -> resolver.resolve(propertyDescriptor)).ifPresent(metadata::setType);
        if (metadata.getType() == null) {
            this.tableMetadata.getDialect().convertSqlType(metadata.getJavaType()).ifPresent(jdbcType -> metadata.setJdbcType((SQLType)jdbcType, metadata.getJavaType()));
        }
        Optional.ofNullable(this.valueCodecResolver).map(resolver -> resolver.resolve(propertyDescriptor).orElseGet(() -> metadata.findFeature(ValueCodecFactory.ID).flatMap(factory -> factory.createValueCodec(metadata)).orElse(null))).ifPresent(arg_0 -> ((RDBColumnMetadata)metadata).setValueCodec(arg_0));
        if (metadata.getValueCodec() instanceof EnumValueCodec && ((EnumValueCodec)metadata.getValueCodec()).isToMask()) {
            metadata.addFeature(EnumFragmentBuilder.eq);
            metadata.addFeature(EnumFragmentBuilder.not);
        }
        this.tableMetadata.addColumn(metadata);
    }

    public void setDataTypeResolver(DataTypeResolver dataTypeResolver) {
        this.dataTypeResolver = dataTypeResolver;
    }

    public void setValueCodecResolver(ValueCodecResolver valueCodecResolver) {
        this.valueCodecResolver = valueCodecResolver;
    }

    private static class ColumnInfo {
        private String name = "";
        private String table = "";
        private boolean nullable;
        private boolean updatable;
        private boolean insertable;
        private int length;
        private int precision;
        private int scale;
        private String columnDefinition = "";

        private ColumnInfo() {
        }

        public static ColumnInfo of(JoinColumn column) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.insertable = column.insertable();
            columnInfo.updatable = column.updatable();
            columnInfo.nullable = column.nullable();
            columnInfo.name = column.name();
            columnInfo.table = column.table();
            return columnInfo;
        }

        public static ColumnInfo of(Column column) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.insertable = column.insertable();
            columnInfo.updatable = column.updatable();
            columnInfo.nullable = column.nullable();
            columnInfo.name = column.name();
            columnInfo.table = column.table();
            columnInfo.length = column.length();
            columnInfo.scale = column.scale();
            columnInfo.precision = column.precision();
            return columnInfo;
        }

        public String getName() {
            return this.name;
        }

        public String getTable() {
            return this.table;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isUpdatable() {
            return this.updatable;
        }

        public boolean isInsertable() {
            return this.insertable;
        }

        public int getLength() {
            return this.length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        public String getColumnDefinition() {
            return this.columnDefinition;
        }
    }
}

