/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.upsert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;

public class DefaultUpsertOperator
extends UpsertOperator {
    private UpsertOperatorParameter parameter = new UpsertOperatorParameter();
    private RDBTableMetadata table;
    private boolean columnValueModel = false;

    public static DefaultUpsertOperator of(RDBTableMetadata table) {
        DefaultUpsertOperator operator = new DefaultUpsertOperator();
        operator.setTable(table);
        return operator;
    }

    @Override
    public UpsertOperator ignoreUpdate(String ... columns) {
        for (UpsertColumn column : this.parameter.getColumns()) {
            for (String col : columns) {
                if (!column.getColumn().equals(col)) continue;
                column.setUpdateIgnore(true);
            }
        }
        return this;
    }

    @Override
    public UpsertOperator columns(String ... columns) {
        for (String column : columns) {
            this.parameter.getColumns().add(UpsertColumn.of(column, false));
        }
        this.columnValueModel = true;
        return this;
    }

    @Override
    public UpsertOperator values(Object ... values) {
        this.parameter.getValues().add(Arrays.asList(values));
        this.columnValueModel = true;
        return this;
    }

    @Override
    public UpsertOperator values(List<Map<String, Object>> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        Set<String> keys = values.get(0).keySet();
        this.columns(keys.toArray(new String[0]));
        for (Map<String, Object> value : values) {
            this.values(keys.stream().map(value::get).toArray());
        }
        return this;
    }

    @Override
    public UpsertOperator where(Consumer<Conditional<?>> dsl) {
        Query query = Query.of();
        dsl.accept((Conditional<?>)query);
        this.parameter.getWhere().addAll(query.getParam().getTerms());
        return this;
    }

    @Override
    public UpsertOperator doNothingOnConflict(boolean doNothing) {
        this.parameter.setDoNothingOnConflict(doNothing);
        return this;
    }

    @Override
    public UpsertOperator value(String column, Object value, boolean ignoreUpdate) {
        if (this.columnValueModel) {
            throw new UnsupportedOperationException("columns or values already set");
        }
        this.parameter.getColumns().add(UpsertColumn.of(column, ignoreUpdate));
        List<List<Object>> values = this.parameter.getValues();
        if (values.isEmpty()) {
            values.add(new ArrayList());
        }
        values.get(0).add(value);
        return this;
    }

    @Override
    public UpsertOperator value(String column, Object value) {
        return this.value(column, value, false);
    }

    @Override
    public SaveResultOperator execute() {
        return ((SaveOrUpdateOperator)this.table.findFeatureNow(SaveOrUpdateOperator.ID)).execute(this.getParameter());
    }

    public UpsertOperatorParameter getParameter() {
        return this.parameter;
    }

    public void setTable(RDBTableMetadata table) {
        this.table = table;
    }
}

