/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.Deadline;
import io.grpc.stub.AbstractStub;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;

public final class CallOption {
    private final UnaryOperator<AbstractStub<?>> operator;

    private CallOption(UnaryOperator<AbstractStub<?>> operator) {
        this.operator = operator;
    }

    public static CallOption deadline(Deadline deadline) {
        Objects.requireNonNull(deadline, "deadline");
        return new CallOption(stub -> stub.withDeadline(deadline));
    }

    public static CallOption deadlineAfter(long duration, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        return new CallOption(stub -> stub.withDeadlineAfter(duration, unit));
    }

    <T extends AbstractStub<T>> T apply(T stub) {
        return (T)((AbstractStub)this.operator.apply(stub));
    }
}

