/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hyperledger.fabric.client.CallOption;

final class CallOptions {
    private final List<CallOption> evaluate;
    private final List<CallOption> endorse;
    private final List<CallOption> submit;
    private final List<CallOption> commitStatus;
    private final List<CallOption> chaincodeEvents;

    private CallOptions(Builder builder) {
        this.evaluate = Collections.unmodifiableList(new ArrayList(builder.evaluate));
        this.endorse = Collections.unmodifiableList(new ArrayList(builder.endorse));
        this.submit = Collections.unmodifiableList(new ArrayList(builder.submit));
        this.commitStatus = Collections.unmodifiableList(new ArrayList(builder.commitStatus));
        this.chaincodeEvents = Collections.unmodifiableList(new ArrayList(builder.chaincodeEvents));
    }

    public static Builder newBuiler() {
        return new Builder();
    }

    private static List<CallOption> append(List<CallOption> current, CallOption ... additional) {
        ArrayList<CallOption> result = new ArrayList<CallOption>(current);
        Collections.addAll(result, additional);
        return result;
    }

    public List<CallOption> getEvaluate(CallOption ... additional) {
        return CallOptions.append(this.evaluate, additional);
    }

    public List<CallOption> getEndorse(CallOption ... additional) {
        return CallOptions.append(this.endorse, additional);
    }

    public List<CallOption> getSubmit(CallOption ... additional) {
        return CallOptions.append(this.submit, additional);
    }

    public List<CallOption> getCommitStatus(CallOption ... additional) {
        return CallOptions.append(this.commitStatus, additional);
    }

    public List<CallOption> getChaincodeEvents(CallOption ... additional) {
        return CallOptions.append(this.chaincodeEvents, additional);
    }

    public static final class Builder {
        private List<CallOption> evaluate = Collections.emptyList();
        private List<CallOption> endorse = Collections.emptyList();
        private List<CallOption> submit = Collections.emptyList();
        private List<CallOption> commitStatus = Collections.emptyList();
        private List<CallOption> chaincodeEvents = Collections.emptyList();

        private Builder() {
        }

        public Builder evaluate(List<CallOption> options) {
            Objects.requireNonNull(options, "evaluate");
            this.evaluate = options;
            return this;
        }

        public Builder endorse(List<CallOption> options) {
            Objects.requireNonNull(options, "endorse");
            this.endorse = options;
            return this;
        }

        public Builder submit(List<CallOption> options) {
            Objects.requireNonNull(options, "submit");
            this.submit = options;
            return this;
        }

        public Builder commitStatus(List<CallOption> options) {
            Objects.requireNonNull(options, "commitStatus");
            this.commitStatus = options;
            return this;
        }

        public Builder chaincodeEvents(List<CallOption> options) {
            Objects.requireNonNull(options, "chaincodeEvents");
            this.chaincodeEvents = options;
            return this;
        }

        public CallOptions build() {
            return new CallOptions(this);
        }
    }
}

