/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.util.Arrays;
import java.util.Objects;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.protos.peer.ChaincodeEventPackage;

final class ChaincodeEventImpl
implements ChaincodeEvent {
    private final long blockNumber;
    private final String transactionId;
    private final String chaincodeName;
    private final String eventName;
    private final byte[] payload;
    private final int hash;

    ChaincodeEventImpl(long blockNumber, ChaincodeEventPackage.ChaincodeEvent event) {
        this.blockNumber = blockNumber;
        this.transactionId = event.getTxId();
        this.chaincodeName = event.getChaincodeId();
        this.eventName = event.getEventName();
        this.payload = event.getPayload().toByteArray();
        this.hash = Objects.hash(blockNumber, this.transactionId, this.chaincodeName, this.eventName);
    }

    @Override
    public long getBlockNumber() {
        return this.blockNumber;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getChaincodeName() {
        return this.chaincodeName;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChaincodeEventImpl)) {
            return false;
        }
        ChaincodeEventImpl that = (ChaincodeEventImpl)other;
        return this.blockNumber == that.blockNumber && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.chaincodeName, that.chaincodeName) && Objects.equals(this.eventName, that.eventName) && Arrays.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return GatewayUtils.toString(this, "blockNumber: " + this.blockNumber, "transactionId: " + this.transactionId, "chaincodeName: " + this.chaincodeName, "eventName: " + this.eventName, "payload: " + Arrays.toString(this.payload));
    }
}

