/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.util.Collections;
import java.util.Iterator;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.ChaincodeEventImpl;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.protos.gateway.ChaincodeEventsResponse;
import org.hyperledger.fabric.protos.peer.ChaincodeEventPackage;

final class ChaincodeEventIterator
implements CloseableIterator<ChaincodeEvent> {
    private final CloseableIterator<ChaincodeEventsResponse> responseIter;
    private Iterator<ChaincodeEventPackage.ChaincodeEvent> eventIter = Collections.emptyIterator();
    private long blockNumber;

    ChaincodeEventIterator(CloseableIterator<ChaincodeEventsResponse> responseIter) {
        this.responseIter = responseIter;
    }

    @Override
    public boolean hasNext() {
        return this.eventIter.hasNext() || this.responseIter.hasNext();
    }

    @Override
    public ChaincodeEvent next() {
        while (!this.eventIter.hasNext()) {
            ChaincodeEventsResponse response = (ChaincodeEventsResponse)this.responseIter.next();
            this.eventIter = response.getEventsList().iterator();
            this.blockNumber = response.getBlockNumber();
        }
        return new ChaincodeEventImpl(this.blockNumber, this.eventIter.next());
    }

    @Override
    public void close() {
        this.responseIter.close();
    }
}

