/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.ChaincodeEventsRequestImpl;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.gateway.SignedChaincodeEventsRequest;
import org.hyperledger.fabric.protos.orderer.Ab;

final class ChaincodeEventsBuilder
implements ChaincodeEventsRequest.Builder {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private final String chaincodeName;
    private final Ab.SeekPosition.Builder startPositionBuilder = Ab.SeekPosition.newBuilder().setNextCommit(Ab.SeekNextCommit.getDefaultInstance());

    ChaincodeEventsBuilder(GatewayClient client, SigningIdentity signingIdentity, String channelName, String chaincodeName) {
        Objects.requireNonNull(channelName, "channel name");
        Objects.requireNonNull(chaincodeName, "chaincode name");
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
        this.chaincodeName = chaincodeName;
    }

    @Override
    public ChaincodeEventsRequest.Builder startBlock(long blockNumber) {
        Ab.SeekSpecified specified = Ab.SeekSpecified.newBuilder().setNumber(blockNumber).build();
        this.startPositionBuilder.setSpecified(specified);
        return this;
    }

    @Override
    public ChaincodeEventsRequest build() {
        SignedChaincodeEventsRequest signedRequest = this.newSignedChaincodeEventsRequestProto(this.chaincodeName);
        return new ChaincodeEventsRequestImpl(this.client, this.signingIdentity, signedRequest);
    }

    private SignedChaincodeEventsRequest newSignedChaincodeEventsRequestProto(String chaincodeName) {
        org.hyperledger.fabric.protos.gateway.ChaincodeEventsRequest request = this.newChaincodeEventsRequestProto(chaincodeName);
        return SignedChaincodeEventsRequest.newBuilder().setRequest(request.toByteString()).build();
    }

    private org.hyperledger.fabric.protos.gateway.ChaincodeEventsRequest newChaincodeEventsRequestProto(String chaincodeName) {
        ByteString creator = ByteString.copyFrom((byte[])this.signingIdentity.getCreator());
        return org.hyperledger.fabric.protos.gateway.ChaincodeEventsRequest.newBuilder().setChannelId(this.channelName).setChaincodeId(chaincodeName).setIdentity(creator).setStartPosition(this.startPositionBuilder.build()).build();
    }
}

