/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.ChaincodeEventIterator;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.gateway.ChaincodeEventsResponse;
import org.hyperledger.fabric.protos.gateway.SignedChaincodeEventsRequest;

final class ChaincodeEventsRequestImpl
implements ChaincodeEventsRequest {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private SignedChaincodeEventsRequest signedRequest;

    ChaincodeEventsRequestImpl(GatewayClient client, SigningIdentity signingIdentity, SignedChaincodeEventsRequest signedRequest) {
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.signedRequest = signedRequest;
    }

    @Override
    public CloseableIterator<ChaincodeEvent> getEvents(CallOption ... options) {
        this.sign();
        CloseableIterator<ChaincodeEventsResponse> responseIter = this.client.chaincodeEvents(this.signedRequest, options);
        return new ChaincodeEventIterator(responseIter);
    }

    @Override
    public byte[] getBytes() {
        return this.signedRequest.toByteArray();
    }

    @Override
    public byte[] getDigest() {
        byte[] message = this.signedRequest.getRequest().toByteArray();
        return this.signingIdentity.hash(message);
    }

    void setSignature(byte[] signature) {
        this.signedRequest = this.signedRequest.toBuilder().setSignature(ByteString.copyFrom((byte[])signature)).build();
    }

    private void sign() {
        if (this.isSigned()) {
            return;
        }
        byte[] digest = this.getDigest();
        byte[] signature = this.signingIdentity.sign(digest);
        this.setSignature(signature);
    }

    private boolean isSigned() {
        return !this.signedRequest.getSignature().isEmpty();
    }
}

