/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import org.hyperledger.fabric.client.Status;
import org.hyperledger.fabric.protos.peer.TransactionPackage;

public class CommitException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Status status;

    private static String message(Status status) {
        TransactionPackage.TxValidationCode code = status.getCode();
        return "Commit of transaction " + status.getTransactionId() + " failed with status code " + code.getNumber() + " (" + code.name() + ")";
    }

    CommitException(Status status) {
        super(CommitException.message(status));
        this.status = status;
    }

    public String getTransactionId() {
        return this.status.getTransactionId();
    }

    public TransactionPackage.TxValidationCode getCode() {
        return this.status.getCode();
    }
}

