/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.util.Objects;
import java.util.Optional;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.CommitException;
import org.hyperledger.fabric.client.CommitStatusException;
import org.hyperledger.fabric.client.Contract;
import org.hyperledger.fabric.client.EndorseException;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.GatewayException;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.ProposalBuilder;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.SubmitException;

final class ContractImpl
implements Contract {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private final String chaincodeName;
    private final String contractName;

    ContractImpl(GatewayClient client, SigningIdentity signingIdentity, String channelName, String chaincodeName) {
        this(client, signingIdentity, channelName, chaincodeName, null);
    }

    ContractImpl(GatewayClient client, SigningIdentity signingIdentity, String channelName, String chaincodeName, String contractName) {
        Objects.requireNonNull(chaincodeName, "chaincode name");
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
        this.chaincodeName = chaincodeName;
        this.contractName = contractName;
    }

    @Override
    public byte[] submitTransaction(String name) throws EndorseException, CommitException, SubmitException, CommitStatusException {
        return this.newProposal(name).build().endorse(new CallOption[0]).submit(new CallOption[0]);
    }

    @Override
    public byte[] submitTransaction(String name, String ... args) throws EndorseException, CommitException, SubmitException, CommitStatusException {
        return this.newProposal(name).addArguments(args).build().endorse(new CallOption[0]).submit(new CallOption[0]);
    }

    @Override
    public byte[] submitTransaction(String name, byte[] ... args) throws EndorseException, CommitException, SubmitException, CommitStatusException {
        return this.newProposal(name).addArguments(args).build().endorse(new CallOption[0]).submit(new CallOption[0]);
    }

    @Override
    public byte[] evaluateTransaction(String name) throws GatewayException {
        return this.newProposal(name).build().evaluate(new CallOption[0]);
    }

    @Override
    public byte[] evaluateTransaction(String name, String ... args) throws GatewayException {
        return this.newProposal(name).addArguments(args).build().evaluate(new CallOption[0]);
    }

    @Override
    public byte[] evaluateTransaction(String name, byte[] ... args) throws GatewayException {
        return this.newProposal(name).addArguments(args).build().evaluate(new CallOption[0]);
    }

    @Override
    public Proposal.Builder newProposal(String transactionName) {
        String qualifiedTxName = this.qualifiedTransactionName(transactionName);
        return new ProposalBuilder(this.client, this.signingIdentity, this.channelName, this.chaincodeName, qualifiedTxName);
    }

    @Override
    public String getChaincodeName() {
        return this.chaincodeName;
    }

    @Override
    public Optional<String> getContractName() {
        return Optional.ofNullable(this.contractName);
    }

    private String qualifiedTransactionName(String name) {
        Objects.requireNonNull(name, "transaction name");
        return this.getContractName().map(contractName -> contractName + ":" + name).orElse(name);
    }
}

