/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.Channel;
import java.util.function.Function;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.Commit;
import org.hyperledger.fabric.client.GatewayImpl;
import org.hyperledger.fabric.client.Network;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.Transaction;
import org.hyperledger.fabric.client.identity.Identity;
import org.hyperledger.fabric.client.identity.Signer;

public interface Gateway
extends AutoCloseable {
    public static Builder newInstance() {
        return new GatewayImpl.Builder();
    }

    public Identity getIdentity();

    public Network getNetwork(String var1);

    public Proposal newSignedProposal(byte[] var1, byte[] var2);

    public Transaction newSignedTransaction(byte[] var1, byte[] var2);

    public Commit newSignedCommit(byte[] var1, byte[] var2);

    public ChaincodeEventsRequest newSignedChaincodeEventsRequest(byte[] var1, byte[] var2);

    @Override
    public void close();

    public static interface Builder {
        public Builder connection(Channel var1);

        public Builder identity(Identity var1);

        public Builder signer(Signer var1);

        public Builder hash(Function<byte[], byte[]> var1);

        public Builder evaluateOptions(CallOption ... var1);

        public Builder endorseOptions(CallOption ... var1);

        public Builder submitOptions(CallOption ... var1);

        public Builder commitStatusOptions(CallOption ... var1);

        public Builder chaincodeEventsOptions(CallOption ... var1);

        public Gateway connect();
    }
}

