/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.CallOptions;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.client.CommitStatusException;
import org.hyperledger.fabric.client.EndorseException;
import org.hyperledger.fabric.client.GatewayException;
import org.hyperledger.fabric.client.GatewayRuntimeException;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.SubmitException;
import org.hyperledger.fabric.protos.gateway.ChaincodeEventsResponse;
import org.hyperledger.fabric.protos.gateway.CommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.CommitStatusResponse;
import org.hyperledger.fabric.protos.gateway.EndorseRequest;
import org.hyperledger.fabric.protos.gateway.EndorseResponse;
import org.hyperledger.fabric.protos.gateway.EvaluateRequest;
import org.hyperledger.fabric.protos.gateway.EvaluateResponse;
import org.hyperledger.fabric.protos.gateway.GatewayGrpc;
import org.hyperledger.fabric.protos.gateway.SignedChaincodeEventsRequest;
import org.hyperledger.fabric.protos.gateway.SignedCommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.SubmitRequest;
import org.hyperledger.fabric.protos.gateway.SubmitResponse;

final class GatewayClient {
    private final GatewayGrpc.GatewayBlockingStub blockingStub;
    private final CallOptions defaultOptions;

    GatewayClient(Channel channel, CallOptions defaultOptions) {
        GatewayUtils.requireNonNullArgument(channel, "No connection details supplied");
        GatewayUtils.requireNonNullArgument(defaultOptions, "defaultOptions");
        this.blockingStub = GatewayGrpc.newBlockingStub(channel);
        this.defaultOptions = defaultOptions;
    }

    public EvaluateResponse evaluate(EvaluateRequest request, CallOption ... options) throws GatewayException {
        GatewayGrpc.GatewayBlockingStub stub = GatewayClient.applyOptions(this.blockingStub, this.defaultOptions.getEvaluate(options));
        try {
            return stub.evaluate(request);
        }
        catch (StatusRuntimeException e) {
            throw new GatewayException(e);
        }
    }

    public EndorseResponse endorse(EndorseRequest request, CallOption ... options) throws EndorseException {
        GatewayGrpc.GatewayBlockingStub stub = GatewayClient.applyOptions(this.blockingStub, this.defaultOptions.getEndorse(options));
        try {
            return stub.endorse(request);
        }
        catch (StatusRuntimeException e) {
            throw new EndorseException(request.getTransactionId(), e);
        }
    }

    public SubmitResponse submit(SubmitRequest request, CallOption ... options) throws SubmitException {
        GatewayGrpc.GatewayBlockingStub stub = GatewayClient.applyOptions(this.blockingStub, this.defaultOptions.getSubmit(options));
        try {
            return stub.submit(request);
        }
        catch (StatusRuntimeException e) {
            throw new SubmitException(request.getTransactionId(), e);
        }
    }

    public CommitStatusResponse commitStatus(SignedCommitStatusRequest request, CallOption ... options) throws CommitStatusException {
        GatewayGrpc.GatewayBlockingStub stub = GatewayClient.applyOptions(this.blockingStub, this.defaultOptions.getCommitStatus(options));
        try {
            return stub.commitStatus(request);
        }
        catch (StatusRuntimeException e) {
            try {
                CommitStatusRequest req = CommitStatusRequest.parseFrom(request.getRequest());
                throw new CommitStatusException(req.getTransactionId(), e);
            }
            catch (InvalidProtocolBufferException protoEx) {
                CommitStatusException commitEx = new CommitStatusException("", e);
                commitEx.addSuppressed(protoEx);
                throw commitEx;
            }
        }
    }

    public CloseableIterator<ChaincodeEventsResponse> chaincodeEvents(SignedChaincodeEventsRequest request, CallOption ... options) {
        GatewayGrpc.GatewayBlockingStub stub = GatewayClient.applyOptions(this.blockingStub, this.defaultOptions.getChaincodeEvents(options));
        return GatewayClient.invokeServerStreamingCall(stub::chaincodeEvents, request);
    }

    private static <T extends AbstractStub<T>> T applyOptions(T stub, List<CallOption> options) {
        T result = stub;
        for (CallOption option : options) {
            result = option.apply(result);
        }
        return result;
    }

    private static <Request, Response> ResponseIterator<Response> invokeServerStreamingCall(Function<Request, Iterator<Response>> call, Request request) {
        Context.CancellableContext context = Context.current().withCancellation();
        try {
            Iterator iterator = (Iterator)context.wrap(() -> (Iterator)call.apply(request)).call();
            return new ResponseIterator(context, iterator);
        }
        catch (StatusRuntimeException e) {
            context.cancel((Throwable)e);
            throw new GatewayRuntimeException(e);
        }
        catch (RuntimeException e) {
            context.cancel((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            context.cancel((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static final class ResponseIterator<T>
    implements CloseableIterator<T> {
        private final Context.CancellableContext context;
        private final Iterator<T> iterator;

        ResponseIterator(Context.CancellableContext context, Iterator<T> iterator) {
            this.context = context;
            this.iterator = iterator;
        }

        @Override
        public void close() {
            this.context.close();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (StatusRuntimeException e) {
                throw new GatewayRuntimeException(e);
            }
        }

        @Override
        public T next() {
            try {
                return this.iterator.next();
            }
            catch (StatusRuntimeException e) {
                throw new GatewayRuntimeException(e);
            }
        }
    }
}

