/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Channel;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.CallOptions;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.ChaincodeEventsRequestImpl;
import org.hyperledger.fabric.client.Commit;
import org.hyperledger.fabric.client.CommitImpl;
import org.hyperledger.fabric.client.Gateway;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.Hash;
import org.hyperledger.fabric.client.Network;
import org.hyperledger.fabric.client.NetworkImpl;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.ProposalImpl;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.Transaction;
import org.hyperledger.fabric.client.TransactionImpl;
import org.hyperledger.fabric.client.identity.Identity;
import org.hyperledger.fabric.client.identity.Signer;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.gateway.CommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.PreparedTransaction;
import org.hyperledger.fabric.protos.gateway.ProposedTransaction;
import org.hyperledger.fabric.protos.gateway.SignedChaincodeEventsRequest;
import org.hyperledger.fabric.protos.gateway.SignedCommitStatusRequest;
import org.hyperledger.fabric.protos.peer.ProposalPackage;

final class GatewayImpl
implements Gateway {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;

    private GatewayImpl(Builder builder) {
        this.signingIdentity = new SigningIdentity(builder.identity, builder.hash, builder.signer);
        this.client = new GatewayClient(builder.grpcChannel, builder.optionsBuilder.build());
    }

    @Override
    public Identity getIdentity() {
        return this.signingIdentity.getIdentity();
    }

    @Override
    public void close() {
    }

    @Override
    public Network getNetwork(String networkName) {
        return new NetworkImpl(this.client, this.signingIdentity, networkName);
    }

    @Override
    public Proposal newSignedProposal(byte[] bytes, byte[] signature) {
        try {
            ProposedTransaction proposedTransaction = ProposedTransaction.parseFrom(bytes);
            ProposalPackage.Proposal proposal = ProposalPackage.Proposal.parseFrom(proposedTransaction.getProposal().getProposalBytes());
            Common.Header header = Common.Header.parseFrom(proposal.getHeader());
            Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom(header.getChannelHeader());
            ProposalImpl result = new ProposalImpl(this.client, this.signingIdentity, channelHeader.getChannelId(), proposedTransaction);
            result.setSignature(signature);
            return result;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Transaction newSignedTransaction(byte[] bytes, byte[] signature) {
        try {
            PreparedTransaction preparedTransaction = PreparedTransaction.parseFrom(bytes);
            TransactionImpl transaction = new TransactionImpl(this.client, this.signingIdentity, preparedTransaction);
            transaction.setSignature(signature);
            return transaction;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Commit newSignedCommit(byte[] bytes, byte[] signature) {
        try {
            SignedCommitStatusRequest signedRequest = SignedCommitStatusRequest.parseFrom(bytes);
            CommitStatusRequest request = CommitStatusRequest.parseFrom(signedRequest.getRequest());
            CommitImpl commit = new CommitImpl(this.client, this.signingIdentity, request.getTransactionId(), signedRequest);
            commit.setSignature(signature);
            return commit;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ChaincodeEventsRequest newSignedChaincodeEventsRequest(byte[] bytes, byte[] signature) {
        try {
            SignedChaincodeEventsRequest signedRequest = SignedChaincodeEventsRequest.parseFrom(bytes);
            ChaincodeEventsRequestImpl result = new ChaincodeEventsRequestImpl(this.client, this.signingIdentity, signedRequest);
            result.setSignature(signature);
            return result;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final class Builder
    implements Gateway.Builder {
        private static final Signer UNDEFINED_SIGNER = digest -> {
            throw new UnsupportedOperationException("No signing implementation supplied");
        };
        private Channel grpcChannel;
        private Identity identity;
        private Signer signer = UNDEFINED_SIGNER;
        private Function<byte[], byte[]> hash = Hash::sha256;
        private final CallOptions.Builder optionsBuilder = CallOptions.newBuiler();

        @Override
        public Builder connection(Channel grpcChannel) {
            Objects.requireNonNull(grpcChannel, "connection");
            this.grpcChannel = grpcChannel;
            return this;
        }

        @Override
        public Builder identity(Identity identity) {
            Objects.requireNonNull(identity, "identity");
            this.identity = identity;
            return this;
        }

        @Override
        public Builder signer(Signer signer) {
            Objects.requireNonNull(signer, "signer");
            this.signer = signer;
            return this;
        }

        @Override
        public Builder hash(Function<byte[], byte[]> hash) {
            Objects.requireNonNull(hash, "hash");
            this.hash = hash;
            return this;
        }

        @Override
        public Builder evaluateOptions(CallOption ... options) {
            this.optionsBuilder.evaluate(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder endorseOptions(CallOption ... options) {
            this.optionsBuilder.endorse(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder submitOptions(CallOption ... options) {
            this.optionsBuilder.submit(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder commitStatusOptions(CallOption ... options) {
            this.optionsBuilder.commitStatus(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder chaincodeEventsOptions(CallOption ... options) {
            this.optionsBuilder.chaincodeEvents(Arrays.asList(options));
            return this;
        }

        @Override
        public GatewayImpl connect() {
            return new GatewayImpl(this);
        }
    }
}

