/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.hyperledger.fabric.client.identity.Identity;
import org.hyperledger.fabric.protos.msp.Identities;

final class GatewayUtils {
    private GatewayUtils() {
    }

    public static String toString(Object o) {
        return o != null ? o.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(o)) : "null";
    }

    public static String toString(Object o, String ... additionalInfo) {
        return GatewayUtils.toString(o) + Arrays.stream(additionalInfo).collect(Collectors.joining(", ", "(", ")"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] concat(byte[] ... bytes) {
        int length = Arrays.stream(bytes).mapToInt(b -> ((byte[])b).length).sum();
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream(length);){
            for (byte[] b2 : bytes) {
                byteOut.write(b2);
            }
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] serializeIdentity(Identity identity) {
        return Identities.SerializedIdentity.newBuilder().setMspid(identity.getMspId()).setIdBytes(ByteString.copyFrom((byte[])identity.getCredentials())).build().toByteArray();
    }

    public static void requireNonNullArgument(Object value, String message) {
        if (null == value) {
            throw new IllegalArgumentException(message);
        }
    }
}

