/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import java.util.Objects;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.ChaincodeEventsBuilder;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.client.Contract;
import org.hyperledger.fabric.client.ContractImpl;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.Network;
import org.hyperledger.fabric.client.SigningIdentity;

final class NetworkImpl
implements Network {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;

    NetworkImpl(GatewayClient client, SigningIdentity signingIdentity, String channelName) {
        Objects.requireNonNull(channelName, "network name");
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
    }

    @Override
    public Contract getContract(String chaincodeName, String contractName) {
        return new ContractImpl(this.client, this.signingIdentity, this.channelName, chaincodeName, contractName);
    }

    @Override
    public Contract getContract(String chaincodeName) {
        return new ContractImpl(this.client, this.signingIdentity, this.channelName, chaincodeName);
    }

    @Override
    public String getName() {
        return this.channelName;
    }

    @Override
    public CloseableIterator<ChaincodeEvent> getChaincodeEvents(String chaincodeName, CallOption ... options) {
        return this.newChaincodeEventsRequest(chaincodeName).build().getEvents(options);
    }

    @Override
    public ChaincodeEventsRequest.Builder newChaincodeEventsRequest(String chaincodeName) {
        return new ChaincodeEventsBuilder(this.client, this.signingIdentity, this.channelName, chaincodeName);
    }
}

