/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.ProposalImpl;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.TransactionContext;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.gateway.ProposedTransaction;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;

final class ProposalBuilder
implements Proposal.Builder {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private final Chaincode.ChaincodeID chaincodeId;
    private final Chaincode.ChaincodeInput.Builder inputBuilder = Chaincode.ChaincodeInput.newBuilder();
    private final ProposalPackage.ChaincodeProposalPayload.Builder payloadBuilder = ProposalPackage.ChaincodeProposalPayload.newBuilder();
    private Set<String> endorsingOrgs = Collections.emptySet();

    ProposalBuilder(GatewayClient client, SigningIdentity signingIdentity, String channelName, String chaincodeName, String transactionName) {
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
        this.chaincodeId = Chaincode.ChaincodeID.newBuilder().setName(chaincodeName).build();
        this.inputBuilder.addArgs(ByteString.copyFrom((String)transactionName, (Charset)StandardCharsets.UTF_8));
    }

    @Override
    public ProposalBuilder addArguments(byte[] ... args) {
        for (byte[] arg : args) {
            this.inputBuilder.addArgs(ByteString.copyFrom((byte[])arg));
        }
        return this;
    }

    @Override
    public ProposalBuilder addArguments(String ... args) {
        for (String arg : args) {
            this.inputBuilder.addArgs(ByteString.copyFrom((String)arg, (Charset)StandardCharsets.UTF_8));
        }
        return this;
    }

    @Override
    public ProposalBuilder putAllTransient(Map<String, byte[]> transientData) {
        transientData.forEach(this::putTransient);
        return this;
    }

    @Override
    public ProposalBuilder putTransient(String key, byte[] value) {
        this.payloadBuilder.putTransientMap(key, ByteString.copyFrom((byte[])value));
        return this;
    }

    @Override
    public ProposalBuilder putTransient(String key, String value) {
        this.payloadBuilder.putTransientMap(key, ByteString.copyFromUtf8((String)value));
        return this;
    }

    @Override
    public ProposalBuilder setEndorsingOrganizations(String ... mspids) {
        this.endorsingOrgs = new HashSet<String>(Arrays.asList(mspids));
        return this;
    }

    @Override
    public Proposal build() {
        return new ProposalImpl(this.client, this.signingIdentity, this.channelName, this.newProposedTransaction());
    }

    private ProposedTransaction newProposedTransaction() {
        TransactionContext context = new TransactionContext(this.signingIdentity);
        return ProposedTransaction.newBuilder().setProposal(this.newSignedProposal(context)).setTransactionId(context.getTransactionId()).addAllEndorsingOrganizations(this.endorsingOrgs).build();
    }

    private ProposalPackage.SignedProposal newSignedProposal(TransactionContext context) {
        return ProposalPackage.SignedProposal.newBuilder().setProposalBytes(this.newProposal(context).toByteString()).build();
    }

    private ProposalPackage.Proposal newProposal(TransactionContext context) {
        return ProposalPackage.Proposal.newBuilder().setHeader(this.newHeader(context).toByteString()).setPayload(this.newChaincodeProposalPayload().toByteString()).build();
    }

    private Common.Header newHeader(TransactionContext context) {
        return Common.Header.newBuilder().setChannelHeader(this.newChannelHeader(context).toByteString()).setSignatureHeader(context.getSignatureHeader().toByteString()).build();
    }

    private Common.ChannelHeader newChannelHeader(TransactionContext context) {
        Instant now = Instant.now();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(now.getEpochSecond()).setNanos(now.getNano()).build();
        return Common.ChannelHeader.newBuilder().setType(Common.HeaderType.ENDORSER_TRANSACTION.getNumber()).setTxId(context.getTransactionId()).setTimestamp(timestamp).setChannelId(this.channelName).setExtension(this.newChaincodeHeaderExtension().toByteString()).setEpoch(0L).build();
    }

    private ProposalPackage.ChaincodeHeaderExtension newChaincodeHeaderExtension() {
        return ProposalPackage.ChaincodeHeaderExtension.newBuilder().setChaincodeId(this.chaincodeId).build();
    }

    private ProposalPackage.ChaincodeProposalPayload newChaincodeProposalPayload() {
        return this.payloadBuilder.setInput(this.newChaincodeInvocationSpec().toByteString()).build();
    }

    private Chaincode.ChaincodeInvocationSpec newChaincodeInvocationSpec() {
        return Chaincode.ChaincodeInvocationSpec.newBuilder().setChaincodeSpec(this.newChaincodeSpec()).build();
    }

    private Chaincode.ChaincodeSpec newChaincodeSpec() {
        return Chaincode.ChaincodeSpec.newBuilder().setChaincodeId(this.chaincodeId).setInput(this.inputBuilder.build()).build();
    }
}

