/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.TransactionPackage;

final class TransactionEnvelopeParser {
    private final String channelName;
    private final ByteString result;

    TransactionEnvelopeParser(Common.Envelope envelope) {
        try {
            Common.Payload payload = Common.Payload.parseFrom(envelope.getPayload());
            this.channelName = this.parseChannelName(payload.getHeader());
            this.result = this.parseResult(payload);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid transaction payload", e);
        }
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ByteString getResult() {
        return this.result;
    }

    private String parseChannelName(Common.Header header) throws InvalidProtocolBufferException {
        Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom(header.getChannelHeader());
        return channelHeader.getChannelId();
    }

    private ByteString parseResult(Common.Payload payload) throws InvalidProtocolBufferException {
        TransactionPackage.Transaction transaction = TransactionPackage.Transaction.parseFrom(payload.getData());
        ArrayList<InvalidProtocolBufferException> parseExceptions = new ArrayList<InvalidProtocolBufferException>();
        for (TransactionPackage.TransactionAction transactionAction : transaction.getActionsList()) {
            try {
                return this.parseResult(transactionAction);
            }
            catch (InvalidProtocolBufferException e) {
                parseExceptions.add(e);
            }
        }
        IllegalArgumentException e = new IllegalArgumentException("No proposal response found");
        parseExceptions.forEach(e::addSuppressed);
        throw e;
    }

    private ByteString parseResult(TransactionPackage.TransactionAction transactionAction) throws InvalidProtocolBufferException {
        TransactionPackage.ChaincodeActionPayload actionPayload = TransactionPackage.ChaincodeActionPayload.parseFrom(transactionAction.getPayload());
        ProposalResponsePackage.ProposalResponsePayload responsePayload = ProposalResponsePackage.ProposalResponsePayload.parseFrom(actionPayload.getAction().getProposalResponsePayload());
        ProposalPackage.ChaincodeAction chaincodeAction = ProposalPackage.ChaincodeAction.parseFrom(responsePayload.getExtension());
        return chaincodeAction.getResponse().getPayload();
    }
}

