/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client.identity;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hyperledger.fabric.client.identity.ECSignature;
import org.hyperledger.fabric.client.identity.Signer;

final class ECPrivateKeySigner
implements Signer {
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private static final String ALGORITHM_NAME = "NONEwithECDSA";
    private final ECPrivateKey privateKey;
    private final BigInteger curveN;
    private final BigInteger halfCurveN;

    ECPrivateKeySigner(ECPrivateKey privateKey) {
        this.privateKey = privateKey;
        this.curveN = privateKey.getParams().getOrder();
        this.halfCurveN = this.curveN.divide(BigInteger.valueOf(2L));
    }

    @Override
    public byte[] sign(byte[] digest) throws GeneralSecurityException {
        byte[] rawSignature = this.generateSignature(digest);
        ECSignature signature = ECSignature.fromBytes(rawSignature);
        signature = this.preventMalleability(signature);
        return signature.getBytes();
    }

    private byte[] generateSignature(byte[] digest) throws GeneralSecurityException {
        Signature signer = Signature.getInstance(ALGORITHM_NAME, PROVIDER);
        signer.initSign(this.privateKey);
        signer.update(digest);
        return signer.sign();
    }

    private ECSignature preventMalleability(ECSignature signature) {
        BigInteger s = signature.getS().getValue();
        if (s.compareTo(this.halfCurveN) > 0) {
            s = this.curveN.subtract(s);
            return new ECSignature(signature.getR(), new ASN1Integer(s));
        }
        return signature;
    }
}

