/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client.identity;

import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import org.hyperledger.fabric.client.identity.Identities;
import org.hyperledger.fabric.client.identity.Identity;

public final class X509Identity
implements Identity {
    private final String mspId;
    private final X509Certificate certificate;
    private final byte[] credentials;

    public X509Identity(String mspId, X509Certificate certificate) {
        this.mspId = mspId;
        this.certificate = certificate;
        this.credentials = Identities.toPemString(certificate).getBytes(StandardCharsets.UTF_8);
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public String getMspId() {
        return this.mspId;
    }

    @Override
    public byte[] getCredentials() {
        return (byte[])this.credentials.clone();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509Identity)) {
            return false;
        }
        X509Identity that = (X509Identity)other;
        return Objects.equals(this.mspId, that.mspId) && Arrays.equals(this.credentials, that.credentials);
    }

    public int hashCode() {
        return Objects.hash(this.mspId, Arrays.hashCode(this.credentials));
    }
}

