/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.jaitools.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtils {
    public static TiledImage createConstantImage(int width, int height, Number value) {
        return ImageUtils.createConstantImage(width, height, new Number[]{value});
    }

    public static TiledImage createConstantImage(int minx, int miny, int width, int height, Number value) {
        return ImageUtils.createConstantImage(minx, miny, width, height, new Number[]{value});
    }

    public static TiledImage createConstantImage(int width, int height, Number[] values) {
        return ImageUtils.createConstantImage(0, 0, width, height, values);
    }

    public static TiledImage createConstantImage(int minx, int miny, int width, int height, Number[] values) {
        Dimension tileSize = JAI.getDefaultTileSize();
        return ImageUtils.createConstantImage(minx, miny, width, height, tileSize.width, tileSize.height, values);
    }

    public static TiledImage createConstantImage(int minx, int miny, int width, int height, int tileWidth, int tileHeight, Number[] values) {
        int i;
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("values array must contain at least 1 value");
        }
        int numBands = values.length;
        double[] doubleValues = null;
        float[] floatValues = null;
        int[] intValues = null;
        Object[] typedValues = null;
        int dataType = 32;
        if (values[0] instanceof Double) {
            doubleValues = new double[values.length];
            dataType = 5;
            for (i = 0; i < numBands; ++i) {
                doubleValues[i] = (Double)values[i];
            }
            typedValues = doubleValues;
        } else if (values[0] instanceof Float) {
            floatValues = new float[values.length];
            dataType = 4;
            for (i = 0; i < numBands; ++i) {
                floatValues[i] = ((Float)values[i]).floatValue();
            }
            typedValues = floatValues;
        } else if (values[0] instanceof Integer) {
            intValues = new int[values.length];
            dataType = 3;
            for (i = 0; i < numBands; ++i) {
                intValues[i] = (Integer)values[i];
            }
            typedValues = intValues;
        } else if (values[0] instanceof Short) {
            intValues = new int[values.length];
            dataType = 2;
            for (i = 0; i < numBands; ++i) {
                intValues[i] = ((Short)values[i]).shortValue();
            }
            typedValues = intValues;
        } else if (values[0] instanceof Byte) {
            intValues = new int[values.length];
            dataType = 0;
            for (i = 0; i < numBands; ++i) {
                intValues[i] = ((Byte)values[i]).byteValue();
            }
            typedValues = intValues;
        } else {
            throw new UnsupportedOperationException("Unsupported data type: " + values[0].getClass().getName());
        }
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)dataType, (int)tileWidth, (int)tileHeight, (int)numBands);
        ColorModel cm = PlanarImage.createColorModel((SampleModel)sm);
        TiledImage tImg = new TiledImage(minx, miny, width, height, 0, 0, sm, cm);
        WritableRaster tile0 = null;
        int tileW = 0;
        int tileH = 0;
        for (int tileY = tImg.getMinTileY(); tileY <= tImg.getMaxTileY(); ++tileY) {
            for (int tileX = tImg.getMinTileX(); tileX <= tImg.getMaxTileX(); ++tileX) {
                WritableRaster raster = tImg.getWritableTile(tileX, tileY);
                WritableRaster child = raster.createWritableTranslatedChild(0, 0);
                if (tile0 == null) {
                    tile0 = child;
                    tileW = tile0.getWidth();
                    tileH = tile0.getHeight();
                    ImageUtils.fillRaster(tile0, tileW, tileH, dataType, typedValues);
                } else {
                    child.setDataElements(0, 0, tile0);
                }
                tImg.releaseWritableTile(tileX, tileY);
            }
        }
        return tImg;
    }

    public static TiledImage createImageFromArray(Number[] array, int width, int height) {
        if (array == null) {
            throw new IllegalArgumentException("array must be non-null");
        }
        if (array.length == 0 || array.length != width * height) {
            throw new IllegalArgumentException("The array must be non-empty and have length width x height");
        }
        Number val = array[0];
        TiledImage img = ImageUtils.createConstantImage(width, height, val);
        if (array[0] instanceof Double) {
            ImageUtils.fillImageAsDouble(img, array, width, height);
        } else if (array[0] instanceof Float) {
            ImageUtils.fillImageAsFloat(img, array, width, height);
        } else if (array[0] instanceof Integer) {
            ImageUtils.fillImageAsInt(img, array, width, height);
        } else if (array[0] instanceof Short) {
            ImageUtils.fillImageAsShort(img, array, width, height);
        } else if (array[0] instanceof Byte) {
            ImageUtils.fillImageAsByte(img, array, width, height);
        } else {
            throw new UnsupportedOperationException("Unsupported data type: " + array[0].getClass().getName());
        }
        return img;
    }

    private static void fillImageAsDouble(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, array[k++].doubleValue());
            }
        }
    }

    private static void fillImageAsFloat(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, array[k++].floatValue());
            }
        }
    }

    private static void fillImageAsInt(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, array[k++].intValue());
            }
        }
    }

    private static void fillImageAsShort(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, (int)array[k++].shortValue());
            }
        }
    }

    private static void fillImageAsByte(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, (int)array[k++].byteValue());
            }
        }
    }

    public static Color[] createRampColours(int numColours) {
        return ImageUtils.createRampColours(numColours, 0.8f, 0.8f);
    }

    public static Color[] createRampColours(int numColours, float saturation, float brightness) {
        return ImageUtils.createRampColours(numColours, 0.0f, 1.0f, saturation, brightness);
    }

    public static Color[] createRampColours(int numColours, float startHue, float endHue, float saturation, float brightness) {
        Color[] colors = new Color[numColours];
        float increment = numColours > 1 ? (endHue - startHue) / (float)(numColours - 1) : 0.0f;
        float hue = startHue;
        for (int i = 0; i < numColours; ++i) {
            int rgb = Color.HSBtoRGB(hue, saturation, brightness);
            colors[i] = new Color(rgb);
            hue += increment;
        }
        return colors;
    }

    public static RenderedImage createDisplayImage(RenderedImage dataImg, Map<Integer, Color> colourTable) {
        if (colourTable.size() > 256) {
            throw new IllegalArgumentException("Number of colours can't be more than 256");
        }
        Integer maxKey = null;
        Integer minKey = null;
        for (Integer key : colourTable.keySet()) {
            if (minKey == null) {
                minKey = maxKey = key;
                continue;
            }
            if (key < minKey) {
                minKey = key;
                continue;
            }
            if (key <= maxKey) continue;
            maxKey = key;
        }
        ParameterBlockJAI pb = null;
        RenderedImage lookupImg = dataImg;
        byte[][] lookup = null;
        int offset = 0;
        if (minKey < 0 || maxKey > 255) {
            lookupImg = ImageUtils.createConstantImage(dataImg.getWidth(), dataImg.getHeight(), 0);
            SortedMap<Integer, Integer> keyTable = CollectionFactory.sortedMap();
            int k = 0;
            for (Integer key : colourTable.keySet()) {
                keyTable.put(key, k++);
            }
            WritableRectIter iter = RectIterFactory.createWritable((WritableRenderedImage)((TiledImage)lookupImg), null);
            while (true) {
                iter.setSample(((Integer)keyTable.get(iter.getSample())).intValue());
                if (!iter.nextPixelDone()) continue;
                iter.startPixels();
                if (!iter.nextLineDone()) continue;
                iter.startLines();
                if (iter.nextBandDone()) break;
            }
            lookup = new byte[3][colourTable.size()];
            for (Integer key : keyTable.keySet()) {
                int index = (Integer)keyTable.get(key);
                int colour = colourTable.get(key).getRGB();
                lookup[0][index] = (byte)((colour & 0xFF0000) >> 16);
                lookup[1][index] = (byte)((colour & 0xFF00) >> 8);
                lookup[2][index] = (byte)(colour & 0xFF);
            }
        } else {
            lookup = new byte[3][maxKey - minKey + 1];
            offset = minKey;
            for (Integer key : colourTable.keySet()) {
                int colour = colourTable.get(key).getRGB();
                lookup[0][key.intValue() - offset] = (byte)((colour & 0xFF0000) >> 16);
                lookup[1][key.intValue() - offset] = (byte)((colour & 0xFF00) >> 8);
                lookup[2][key.intValue() - offset] = (byte)(colour & 0xFF);
            }
        }
        pb = new ParameterBlockJAI("Lookup");
        pb.setSource("source0", (Object)lookupImg);
        pb.setParameter("table", (Object)new LookupTableJAI(lookup, offset));
        RenderedOp displayImg = JAI.create((String)"Lookup", (ParameterBlock)pb);
        return displayImg;
    }

    public static List<RenderedImage> getBandsAsImages(RenderedImage img) {
        List<RenderedImage> images = CollectionFactory.list();
        if (img != null) {
            int numBands = img.getSampleModel().getNumBands();
            int band = 0;
            while (band < numBands) {
                ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
                pb.setSource("source0", (Object)img);
                pb.setParameter("bandindices", (Object)new int[]{band++});
                RenderedOp bandImg = JAI.create((String)"BandSelect", (ParameterBlock)pb);
                images.add((RenderedImage)bandImg);
            }
        }
        return images;
    }

    public static List<RenderedImage> getBandsAsImages(RenderedImage img, Collection<Integer> bandIndices) {
        List<RenderedImage> images = CollectionFactory.list();
        if (img != null) {
            int numBands = img.getSampleModel().getNumBands();
            SortedSet<Integer> sortedIndices = CollectionFactory.sortedSet();
            sortedIndices.addAll(bandIndices);
            if (sortedIndices.first() < 0 || sortedIndices.last() >= numBands) {
                throw new IllegalArgumentException("band index out of bounds");
            }
            for (Integer band : sortedIndices) {
                ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
                pb.setSource("source0", (Object)img);
                pb.setParameter("bandindices", (Object)new int[]{band});
                RenderedOp bandImg = JAI.create((String)"BandSelect", (ParameterBlock)pb);
                images.add((RenderedImage)bandImg);
            }
        }
        return images;
    }

    private static void fillRaster(WritableRaster wr, int w, int h, int dataType, Object typedValues) {
        switch (dataType) {
            case 5: {
                double[] values = (double[])typedValues;
                ImageUtils.fillRasterDouble(wr, w, h, values);
                break;
            }
            case 4: {
                float[] values = (float[])typedValues;
                ImageUtils.fillRasterFloat(wr, w, h, values);
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                int[] values = (int[])typedValues;
                ImageUtils.fillRasterInt(wr, w, h, values);
            }
        }
    }

    private static void fillRasterDouble(WritableRaster wr, int w, int h, double[] values) {
        WritableRaster child = wr.createWritableTranslatedChild(0, 0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                child.setPixel(x, y, values);
            }
        }
    }

    private static void fillRasterFloat(WritableRaster wr, int w, int h, float[] values) {
        WritableRaster child = wr.createWritableTranslatedChild(0, 0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                child.setPixel(x, y, values);
            }
        }
    }

    private static void fillRasterInt(WritableRaster wr, int w, int h, int[] values) {
        WritableRaster child = wr.createWritableTranslatedChild(0, 0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                child.setPixel(x, y, values);
            }
        }
    }
}

