/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jaitools.numeric.HistogramException;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.RangeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram<T extends Number> {
    public static final int NO_BIN = -1;
    private List<Bin> bins = new ArrayList<Bin>();
    private boolean needsSort;

    public void addBin(Range<T> range) throws HistogramException {
        for (Bin bin : this.bins) {
            if (!range.intersects(bin.range)) continue;
            throw new HistogramException(range.toString() + " overlaps existing bin" + bin.toString());
        }
        this.bins.add(new Bin(range));
        this.needsSort = true;
    }

    public int addValue(T value) {
        int index = this.getBinForValue(value);
        if (index != -1) {
            ++this.bins.get((int)index).count;
        }
        return index;
    }

    public void addValues(List<T> values) {
        this.ensureBinsSorted();
        int curIndex = -1;
        Bin bin = null;
        for (Number value : values) {
            int index = this.findBin(value);
            if (index == -1) continue;
            if (index != curIndex) {
                bin = this.bins.get(index);
                curIndex = index;
            }
            ++bin.count;
        }
    }

    public int getBinForValue(T value) {
        this.ensureBinsSorted();
        return this.findBin(value);
    }

    public List<Integer> getBinForValues(List<T> values) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Number value : values) {
            indices.add(this.getBinForValue(value));
        }
        return indices;
    }

    public int size() {
        return this.bins.size();
    }

    public List<Integer> getCounts() {
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (Bin bin : this.bins) {
            counts.add(bin.count);
        }
        return counts;
    }

    private int findBin(T value) {
        int index = 0;
        for (Bin bin : this.bins) {
            if (bin.range.contains(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void ensureBinsSorted() {
        if (this.needsSort) {
            Collections.sort(this.bins, new BinComparator());
            this.needsSort = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BinComparator
    implements Comparator<Bin> {
        private RangeComparator<T> rc = new RangeComparator();

        private BinComparator() {
        }

        @Override
        public int compare(Bin b1, Bin b2) {
            RangeComparator.Result result = this.rc.compare(b1.range, b2.range);
            switch (result.getNotation().charAt(1)) {
                case '<': {
                    return -1;
                }
                case '>': {
                    return 1;
                }
            }
            return 0;
        }
    }

    private class Bin {
        Range<T> range;
        int count;

        public Bin(Range r) {
            this.range = new Range(r);
            this.count = 0;
        }
    }
}

