/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.services;

import java.util.Arrays;
import javax.naming.Name;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.ldap.services.LdapServiceMapper;
import org.jasig.cas.adaptors.ldap.util.SpringLdapUtils;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public final class DefaultLdapServiceMapper
extends LdapServiceMapper {
    @NotNull
    private String objectclass = "casService";
    @NotNull
    private String serviceIdAttribute = "casServiceUrlPattern";
    @NotNull
    private String idAttribute = "casServiceId";
    @NotNull
    private String serviceDescriptionAttribute = "description";
    @NotNull
    private String namingAttribute = "cn";
    @NotNull
    private String serviceEnabledAttribute = "casServiceEnabled";
    @NotNull
    private String serviceSsoEnabledAttribute = "casServiceSsoEnabled";
    @NotNull
    private String serviceAnonymousAccessAttribute = "casServiceAnonymousAccess";
    @NotNull
    private String serviceAllowedToProxyAttribute = "casServiceAllowedToProxy";
    @NotNull
    private String serviceThemeAttribute = "casServiceTheme";
    @NotNull
    private String serviceAllowedAttributesAttribute = "casAllowedAttributes";

    protected RegisteredService doMapFromContext(DirContextOperations ctx) {
        RegisteredServiceImpl s = new RegisteredServiceImpl();
        s.setId(Long.parseLong(ctx.getStringAttribute(this.idAttribute)));
        s.setServiceId(ctx.getStringAttribute(this.serviceIdAttribute));
        s.setName(ctx.getStringAttribute(this.namingAttribute));
        s.setEnabled(SpringLdapUtils.getBoolean(ctx, this.serviceEnabledAttribute).booleanValue());
        s.setAllowedToProxy(SpringLdapUtils.getBoolean(ctx, this.serviceAllowedToProxyAttribute).booleanValue());
        s.setAnonymousAccess(SpringLdapUtils.getBoolean(ctx, this.serviceAnonymousAccessAttribute).booleanValue());
        s.setDescription(ctx.getStringAttribute(this.serviceDescriptionAttribute));
        s.setSsoEnabled(SpringLdapUtils.getBoolean(ctx, this.serviceSsoEnabledAttribute).booleanValue());
        s.setTheme(ctx.getStringAttribute(this.serviceThemeAttribute));
        s.setAllowedAttributes(Arrays.asList(ctx.getStringAttributes(this.serviceAllowedAttributesAttribute)));
        return s;
    }

    protected DirContextAdapter doMapToContext(RegisteredService service, DirContextAdapter ctx) {
        ctx.setAttributeValue(this.idAttribute, (Object)String.valueOf(service.getId()));
        ctx.setAttributeValue(this.serviceIdAttribute, (Object)service.getServiceId());
        SpringLdapUtils.setBoolean((DirContextOperations)ctx, this.serviceEnabledAttribute, service.isEnabled());
        SpringLdapUtils.setBoolean((DirContextOperations)ctx, this.serviceAllowedToProxyAttribute, service.isAllowedToProxy());
        SpringLdapUtils.setBoolean((DirContextOperations)ctx, this.serviceAnonymousAccessAttribute, service.isAnonymousAccess());
        SpringLdapUtils.setBoolean((DirContextOperations)ctx, this.serviceSsoEnabledAttribute, service.isSsoEnabled());
        ctx.setAttributeValue(this.serviceThemeAttribute, (Object)service.getTheme());
        ctx.setAttributeValues(this.serviceAllowedAttributesAttribute, (Object[])service.getAllowedAttributes().toArray(new String[service.getAllowedAttributes().size()]), false);
        ctx.setAttributeValue(this.serviceDescriptionAttribute, (Object)service.getDescription());
        if (!SpringLdapUtils.containsObjectClass(ctx, this.objectclass)) {
            ctx.addAttributeValue("objectclass", (Object)this.objectclass);
        }
        return ctx;
    }

    protected DirContextAdapter createCtx(String parentDn, RegisteredService servivce) {
        DistinguishedName dn = new DistinguishedName(parentDn);
        dn.add(this.namingAttribute, servivce.getName());
        return new DirContextAdapter((Name)dn);
    }

    protected Filter getSearchFilter(Long id) {
        return new AndFilter().and(this.getLoadFilter()).and((Filter)new EqualsFilter(this.idAttribute, String.valueOf(id)));
    }

    protected Filter getLoadFilter() {
        return new EqualsFilter("objectclass", this.objectclass);
    }

    public void setObjectclass(String objectclass) {
        this.objectclass = objectclass;
    }

    public void setServiceIdAttribute(String serviceIdAttribute) {
        this.serviceIdAttribute = serviceIdAttribute;
    }

    public void setIdAttribute(String idAttribute) {
        this.idAttribute = idAttribute;
    }

    public void setServiceDescriptionAttribute(String serviceDescriptionAttribute) {
        this.serviceDescriptionAttribute = serviceDescriptionAttribute;
    }

    public void setNamingAttribute(String namingAttribute) {
        this.namingAttribute = namingAttribute;
    }

    public void setServiceEnabledAttribute(String serviceEnabledAttribute) {
        this.serviceEnabledAttribute = serviceEnabledAttribute;
    }

    public void setServiceSsoEnabledAttribute(String serviceSsoEnabledAttribute) {
        this.serviceSsoEnabledAttribute = serviceSsoEnabledAttribute;
    }

    public void setServiceAnonymousAccessAttribute(String serviceAnonymousAccessAttribute) {
        this.serviceAnonymousAccessAttribute = serviceAnonymousAccessAttribute;
    }

    public void setServiceAllowedToProxyAttribute(String serviceAllowedToProxyAttribute) {
        this.serviceAllowedToProxyAttribute = serviceAllowedToProxyAttribute;
    }

    public void setServiceThemeAttribute(String serviceThemeAttribute) {
        this.serviceThemeAttribute = serviceThemeAttribute;
    }

    public void setServiceAllowedAttributesAttribute(String serviceAllowedAttributesAttribute) {
        this.serviceAllowedAttributesAttribute = serviceAllowedAttributesAttribute;
    }
}

