/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public final class CasDefaultFlowUrlHandler
extends DefaultFlowUrlHandler {
    public static final String DEFAULT_FLOW_EXECUTION_KEY_PARAMETER = "execution";
    private String flowExecutionKeyParameter = "execution";

    public void setFlowExecutionKeyParameter(String parameterName) {
        this.flowExecutionKeyParameter = parameterName;
    }

    public String getFlowExecutionKey(HttpServletRequest request) {
        return request.getParameter(this.flowExecutionKeyParameter);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        String encoding = this.getEncodingScheme(request);
        builder.append(request.getRequestURI());
        builder.append('?');
        LinkedHashMap<String, String[]> flowParams = new LinkedHashMap<String, String[]>(request.getParameterMap());
        flowParams.put(this.flowExecutionKeyParameter, new String[]{flowExecutionKey});
        builder.append(this.toQueryString(flowParams, encoding));
        return builder.toString();
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        return String.valueOf(request.getRequestURI()) + (request.getQueryString() != null ? String.valueOf('?') + request.getQueryString() : "");
    }

    private String toQueryString(Map<String, String[]> flowParams, String encoding) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : flowParams.entrySet()) {
            if (builder.length() != 0) {
                builder.append("&");
            }
            builder.append(this.encodeMultiParameter(entry.getKey(), entry.getValue(), encoding));
        }
        return builder.toString();
    }

    private String encodeMultiParameter(String key, String[] values, String encoding) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (builder.length() != 0) {
                builder.append("&");
            }
            builder.append(this.encodeSingleParameter(key, value, encoding));
            ++n2;
        }
        return builder.toString();
    }

    private String encodeSingleParameter(String key, String value, String encoding) {
        return String.valueOf(this.urlEncode(key, encoding)) + "=" + this.urlEncode(value, encoding);
    }

    private String urlEncode(String value, String encodingScheme) {
        try {
            return URLEncoder.encode(value, encodingScheme);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Cannot url encode " + value);
        }
    }
}

