/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.net.URI;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.registry.TicketRegistrySupport;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="generateServiceTicketAction")
public final class GenerateServiceTicketAction
extends AbstractAction {
    @NotNull
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @NotNull
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;

    protected Event doExecute(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        try {
            Authentication authentication = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicket);
            if (authentication == null) {
                throw new InvalidTicketException((Throwable)new AuthenticationException(), ticketGrantingTicket);
            }
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
            WebUtils.putService((RequestContext)context, (Service)service);
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)registeredService.getAccessStrategy().getUnauthorizedRedirectUrl());
            DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            AuthenticationContext authenticationContext = builder.collect(WebUtils.getCredential((RequestContext)context)).collect(authentication).build((Service)service);
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, (Service)service, authenticationContext);
            WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
            return this.success();
        }
        catch (AuthenticationException e) {
            this.logger.error((Object)"Could not verify credentials to grant service ticket", (Throwable)e);
        }
        catch (AbstractTicketException e) {
            if (e instanceof InvalidTicketException) {
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
            }
            if (this.isGatewayPresent(context)) {
                return this.result("gateway");
            }
            return this.newEvent("error", (Exception)((Object)e));
        }
        return this.error();
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setAuthenticationSystemSupport(AuthenticationSystemSupport authenticationSystemSupport) {
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    public void setTicketRegistrySupport(TicketRegistrySupport ticketRegistrySupport) {
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    protected boolean isGatewayPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get("gateway"));
    }

    private Event newEvent(String id, Exception error) {
        return new Event((Object)this, id, (AttributeMap)new LocalAttributeMap("error", (Object)error));
    }
}

