/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.NullPrincipal;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="genericSuccessViewAction")
public final class GenericSuccessViewAction {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CentralAuthenticationService centralAuthenticationService;

    @Autowired
    public GenericSuccessViewAction(@Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public Principal getAuthenticationPrincipal(String ticketGrantingTicketId) {
        try {
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            return ticketGrantingTicket.getAuthentication().getPrincipal();
        }
        catch (InvalidTicketException e) {
            this.logger.warn(e.getMessage());
            this.logger.debug("In the absence of valid TGT, the authentication principal cannot be determined. Returning {}", (Object)NullPrincipal.class.getSimpleName());
            return NullPrincipal.getInstance();
        }
    }
}

