/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.web.support.CookieRetrievingCookieGenerator;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="terminateSessionAction")
public final class TerminateSessionAction {
    private final EventFactorySupport eventFactorySupport = new EventFactorySupport();
    @NotNull
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    @NotNull
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieRetrievingCookieGenerator warnCookieGenerator;
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();

    public Event terminate(RequestContext context) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (tgtId == null) {
            HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
            tgtId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        }
        if (tgtId != null) {
            List logoutRequests = this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
            WebUtils.putLogoutRequests((RequestContext)context, (List)logoutRequests);
        }
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        this.ticketGrantingTicketCookieGenerator.removeCookie(response);
        this.warnCookieGenerator.removeCookie(response);
        return this.eventFactorySupport.success((Object)this);
    }
}

