/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.AbstractOperationTransformer;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.jmx.Attribute;
import org.jboss.as.jmx.Element;
import org.jboss.as.jmx.ExposeModelResource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXSubsystemRootResource;
import org.jboss.as.jmx.JmxLogger;
import org.jboss.as.jmx.Namespace;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMXExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jmx";
    private static final String RESOURCE_NAME = JMXExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final JMXSubsystemParser_1_2 parserCurrent = new JMXSubsystemParser_1_2();
    static final JMXSubsystemParser_1_1 parser11 = new JMXSubsystemParser_1_1();
    static final JMXSubsystemParser_1_0 parser10 = new JMXSubsystemParser_1_0();
    static final JMXSubsystemWriter writer = new JMXSubsystemWriter();
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, JMXExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1, 0);
        registration.registerSubsystemModel((ResourceDefinition)new JMXSubsystemRootResource());
        registration.registerXMLElementWriter((XMLElementWriter)writer);
        if (context.isRegisterTransformers()) {
            this.registerTransformers1_0_0(registration);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_0.getUriString(), (XMLElementReader)parser10);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_1.getUriString(), (XMLElementReader)parser11);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_2.getUriString(), (XMLElementReader)parserCurrent);
    }

    private static ModelNode createAddOperation() {
        return JMXExtension.createOperation("add", new String[0]);
    }

    private static ModelNode createOperation(String name, String ... addressElements) {
        ModelNode op = new ModelNode();
        op.get("operation").set(name);
        op.get("address").add("subsystem", SUBSYSTEM_NAME);
        for (int i = 0; i < addressElements.length; ++i) {
            op.get("address").add(addressElements[i], addressElements[++i]);
        }
        return op;
    }

    private void registerTransformers1_0_0(SubsystemRegistration registration) {
        TransformersSubRegistration transformers = registration.registerModelTransformers((ModelVersionRange)ModelVersion.create((int)1, (int)0, (int)0), new ResourceTransformer(){

            public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ModelNode model = resource.getModel();
                Resource exposeResolvedResource = resource.getChild(PathElement.pathElement((String)"expose-model", (String)"resolved"));
                boolean showModel = false;
                if (exposeResolvedResource != null) {
                    showModel = model.isDefined();
                }
                model.get("show-model").set(showModel);
                ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
                for (String type : resource.getChildTypes()) {
                    if (type.equals("expose-model")) continue;
                    for (Resource.ResourceEntry child : resource.getChildren(type)) {
                        childContext.processChild(child.getPathElement(), (Resource)child);
                    }
                }
            }
        });
        TransformersSubRegistration expressions = transformers.registerSubResource(ExposeModelResourceExpression.INSTANCE.getPathElement());
        expressions.discardOperations(new String[]{"add", "remove", "write-attribute", "read-attribute"});
        TransformersSubRegistration resolved = transformers.registerSubResource(ExposeModelResourceResolved.INSTANCE.getPathElement());
        resolved.discardOperations(new String[]{"write-attribute"});
        resolved.registerOperationTransformer("add", (OperationTransformer)new AbstractOperationTransformer(){

            protected ModelNode transform(TransformationContext context, PathAddress address, ModelNode operation) {
                ModelNode node = new ModelNode();
                node.get("operation").set("write-attribute");
                node.get("address").set(address.subAddress(0, address.size() - 1).toModelNode());
                node.get("name").set("show-model");
                node.get("value").set(true);
                return node;
            }
        });
        resolved.registerOperationTransformer("remove", (OperationTransformer)new AbstractOperationTransformer(){

            protected ModelNode transform(TransformationContext context, PathAddress address, ModelNode operation) {
                ModelNode node = new ModelNode();
                node.get("operation").set("write-attribute");
                node.get("address").set(address.subAddress(0, address.size() - 1).toModelNode());
                node.get("name").set("show-model");
                node.get("value").set(false);
                return node;
            }
        });
        resolved.registerOperationTransformer("read-attribute", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, final ModelNode operation) {
                return new OperationTransformer.TransformedOperation(null, new OperationResultTransformer(){

                    public ModelNode transformResult(ModelNode result) {
                        if (operation.get("name").asString().equals("domain-name")) {
                            result.get("result").set("jboss.as");
                        }
                        result.get("outcome").set("success");
                        result.get("result");
                        return result;
                    }
                });
            }
        });
        RejectExpressionValuesTransformer rejectTransformer = new RejectExpressionValuesTransformer(new AttributeDefinition[]{RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT});
        TransformersSubRegistration remoting = transformers.registerSubResource(RemotingConnectorResource.REMOTE_CONNECTOR_CONFIG_PATH, (ResourceTransformer)rejectTransformer);
        remoting.registerOperationTransformer("add", (OperationTransformer)rejectTransformer);
        remoting.registerOperationTransformer("write-attribute", rejectTransformer.getWriteAttributeTransformer());
    }

    private static class JMXSubsystemWriter
    implements XMLStreamConstants,
    XMLElementWriter<SubsystemMarshallingContext> {
        private JMXSubsystemWriter() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            Namespace schemaVer = Namespace.CURRENT;
            ModelNode node = context.getModelNode();
            context.startSubsystemElement(schemaVer.getUriString(), false);
            if (node.hasDefined("expose-model")) {
                ModelNode showModel = node.get("expose-model");
                if (showModel.hasDefined("resolved")) {
                    writer.writeEmptyElement(Element.EXPOSE_RESOLVED_MODEL.getLocalName());
                    ExposeModelResourceResolved.DOMAIN_NAME.marshallAsAttribute(showModel.get("resolved"), false, (XMLStreamWriter)writer);
                    ExposeModelResourceResolved.PROPER_PROPERTY_FORMAT.marshallAsAttribute(showModel.get("resolved"), false, (XMLStreamWriter)writer);
                }
                if (showModel.hasDefined("expression")) {
                    writer.writeEmptyElement(Element.EXPOSE_EXPRESSION_MODEL.getLocalName());
                    ExposeModelResourceExpression.DOMAIN_NAME.marshallAsAttribute(showModel.get("expression"), false, (XMLStreamWriter)writer);
                }
            }
            if (node.hasDefined("remoting-connector")) {
                writer.writeStartElement(Element.REMOTING_CONNECTOR.getLocalName());
                ModelNode resourceModel = node.get("remoting-connector").get(JMXExtension.SUBSYSTEM_NAME);
                RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.marshallAsAttribute(resourceModel, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static class JMXSubsystemParser_1_2
    extends JMXSubsystemParser_1_1 {
        private JMXSubsystemParser_1_2() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showResolvedModel = false;
            boolean showExpressionModel = false;
            boolean connectorAdd = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(JMXExtension.createAddOperation());
            block5: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case EXPOSE_RESOLVED_MODEL: {
                        if (showResolvedModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.EXPOSE_RESOLVED_MODEL.getLocalName());
                        }
                        showResolvedModel = true;
                        list.add(this.parseShowModelElement(reader, "resolved"));
                        continue block5;
                    }
                    case EXPOSE_EXPRESSION_MODEL: {
                        if (showExpressionModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.EXPOSE_EXPRESSION_MODEL.getLocalName());
                        }
                        showExpressionModel = true;
                        list.add(this.parseShowModelElement(reader, "expression"));
                        continue block5;
                    }
                    case REMOTING_CONNECTOR: {
                        if (connectorAdd) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.REMOTING_CONNECTOR.getLocalName());
                        }
                        connectorAdd = true;
                        list.add(this.parseRemoteConnector(reader));
                        continue block5;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private ModelNode parseShowModelElement(XMLExtendedStreamReader reader, String showModelChild) throws XMLStreamException {
            ModelNode op = JMXExtension.createOperation("add", new String[]{"expose-model", showModelChild});
            Object domainName = null;
            Object properPropertyFormat = null;
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DOMAIN_NAME: {
                        ExposeModelResource.getDomainNameAttribute(showModelChild).parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block4;
                    }
                    case PROPER_PROPETY_FORMAT: {
                        if (showModelChild.equals("resolved")) {
                            ExposeModelResourceResolved.PROPER_PROPERTY_FORMAT.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                            continue block4;
                        }
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (domainName == null && properPropertyFormat == null) {
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            }
            return op;
        }
    }

    private static class JMXSubsystemParser_1_1
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        private JMXSubsystemParser_1_1() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showModel = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            Object connectorAdd = null;
            list.add(JMXExtension.createAddOperation());
            block4: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case SHOW_MODEL: {
                        if (showModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SHOW_MODEL.getLocalName());
                        }
                        if (this.parseShowModelElement(reader)) {
                            ModelNode op = JMXExtension.createOperation("add", new String[]{"expose-model", "resolved"});
                            op.get("proper-property-format").set(false);
                            list.add(op);
                        }
                        showModel = true;
                        continue block4;
                    }
                    case REMOTING_CONNECTOR: {
                        if (connectorAdd != null) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.REMOTING_CONNECTOR.getLocalName());
                        }
                        list.add(this.parseRemoteConnector(reader));
                        continue block4;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        protected ModelNode parseRemoteConnector(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode connector = new ModelNode();
            connector.get("operation").set("add");
            connector.get("address").add("subsystem", JMXExtension.SUBSYSTEM_NAME).add("remoting-connector", JMXExtension.SUBSYSTEM_NAME);
            int count = reader.getAttributeCount();
            block3: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case USE_MANAGEMENT_ENDPOINT: {
                        RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return connector;
        }

        private boolean parseShowModelElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"value");
            return ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
        }
    }

    private static class JMXSubsystemParser_1_0
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        private JMXSubsystemParser_1_0() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(JMXExtension.createAddOperation());
            boolean gotConnector = false;
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case JMX_CONNECTOR: {
                        if (gotConnector) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.JMX_CONNECTOR.getLocalName());
                        }
                        this.parseConnector(reader);
                        gotConnector = true;
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseConnector(XMLExtendedStreamReader reader) throws XMLStreamException {
            JmxLogger.ROOT_LOGGER.jmxConnectorNotSupported();
            String serverBinding = null;
            String registryBinding = null;
            int count = reader.getAttributeCount();
            block4: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case SERVER_BINDING: {
                        serverBinding = value;
                        continue block4;
                    }
                    case REGISTRY_BINDING: {
                        registryBinding = value;
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (serverBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SERVER_BINDING));
            }
            if (registryBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REGISTRY_BINDING));
            }
        }
    }
}

